/* $ZEL: sis1100_reset.c,v 1.3.2.2 2003/08/07 11:51:42 wuestner Exp $ */

/*
 * Copyright (c) 2001-2003
 * 	Willi Erven, Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/iobuf.h>
#include <linux/mm.h>
#include <linux/pci.h>
#include <linux/slab.h>

#include "sis1100_sc.h"

/* only used in initialisation; no need for semaphores */

void sis1100_reset_plx(struct SIS1100_softc* sc)
{
    u_int32_t conf_3C;
    int c;

    pci_read_config_dword(sc->pcidev, 0x3c, &conf_3C);

    *((sc)->plxmembase+0x6f)=0x40;
    wmb();
    *((sc)->plxmembase+0x6f)=0x00;
    wmb();
    *((sc)->plxmembase+0x6f)=0x20;
    mb();
    c=0;
    while ((!(plxreadreg(sc, LAS0RR)) || (c<10)) && (++c<50));
    *((sc)->plxmembase+0x6f)=0x00;

    pci_write_config_dword(sc->pcidev, 0x3c, conf_3C);
}
