/* $ZEL: sis3100_sharc_read.c,v 1.1.2.3 2003/08/07 11:51:46 wuestner Exp $ */

/*
 * Copyright (c) 2001-2003
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <linux/module.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/wrapper.h>
#include <linux/pci.h>
#include <asm/uaccess.h>

#include "sis1100_sc.h"

static int
check_range(struct SIS1100_softc* sc, const char* buf, size_t count, loff_t pos)
{
#if 0
    /* start addr out of range? */
    
    if ((pos<0) || (pos>=sc->sharc_size)) {
    	printk(KERN_INFO "sis3100sh_r/w: start addr out of range\n");
    	return -EINVAL;
    }
    /* end addr out of range? */
    if ((pos+count>sc->sharc_size)||(pos+count<pos)) {
    	printk(KERN_INFO "sis3100sh_r/w: end addr out of range\n");
    	return -EINVAL;
    }
#endif
    return 0;
}

ssize_t sis3100sharc_read(struct file* file, char* buf, size_t count,
    loff_t* ppos)
{
    struct SIS1100_softc* sc=SIS1100SC(file);
    struct SIS1100_fdata* fd=SIS1100FD(file);
    int res;

    if (!sc->remote_ok) return -ENXIO;
    if ((res=check_range(sc, buf, count, *ppos)<0)) return res;

    if (count==4) {
        u_int32_t var;
        if(sis1100_tmp_read(sc, *ppos, -1/*am*/, 4/*datasize*/, 6/*space*/,
                &var)!=0)
            res=-EIO;
        else {
	    __put_user(var, (u_int32_t*)buf);
            res=count;
        }
    } else {
        printk(KERN_INFO "calling sis1100_read_dma\n");
        res=sis1100_read_dma(fd, *ppos, -1/*am*/, 4/*datasize*/, 6/*space*/,
            0, count, buf, &fd->last_prot_err);
    }

    if (res<0)
	return res;
    else {
	*ppos+=res;
	return res;
    }
}

ssize_t sis3100sharc_write(struct file* file, const char* buf, size_t count,
    loff_t* ppos)
{
    struct SIS1100_softc* sc=SIS1100SC(file);
    struct SIS1100_fdata* fd=SIS1100FD(file);
    int res;

    if (!sc->remote_ok) return -ENXIO;
    if ((res=check_range(sc, buf, count, *ppos))<0) return res;


    if (count==4) {
        u_int32_t data;
        __get_user(data, (u_int32_t*)buf);
        if (sis1100_tmp_write(sc, *ppos, -1/*am*/, 4/*datasize*/,
                6/*space*/, data)!=0)
            res=-EIO;
        else
            res=count;
    } else {
        res=sis1100_write_dma(fd, *ppos, -1/*am*/,
                4/*datasize*/, 6/*space*/, 0, count, buf, &fd->last_prot_err);
    }

    if (res<0)
	return res;
    else {
	*ppos+=res;
	return res;
    }
}

/* SEEK_... normally defined in stdio.h, fcntl.h and unistd.h */
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

loff_t sis3100sharc_llseek(struct file* file, loff_t offset, int orig)
{
    struct SIS1100_softc* sc=SIS1100SC(file);
    /*loff_t old=file->f_pos;*/
/*
    printk(KERN_INFO "sis3100sharc_seek: offset=%Ld, orig=%d\n", offset, orig);
*/
    switch (orig) {
    	case SEEK_SET: file->f_pos=offset; break;
    	case SEEK_CUR: file->f_pos+=offset; break;
    	case SEEK_END:
	    file->f_pos=sc->sharc_size+offset;
	    break;
    }
#if 0
    if ((file->f_pos<0) || (file->f_pos>sc->sharc_size)) {
        file->f_pos=old;
    	return -EINVAL;
    }
#endif
    return file->f_pos;
}
