#define _GNU_SOURCE
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>


#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"


/*
int soll_data ;
int max_lword_cnt ;
int loop_cnt ;
*/

int vme_A24DMA_D16_read(int p, u_int32_t vme_adr, u_int32_t* vme_data,
                      u_int32_t req_num_of_lwords, u_int32_t* got_num_of_lwords);


/****************************************************************************/
int main(int argc, char* argv[])
{

#define MAX_NUMBER_LWORDS 0x100000  

int p;
int mod_base;
int no_of_lwords ;
int i;

u_int32_t blt_data[MAX_NUMBER_LWORDS] ;
u_int32_t get_lwords ;
int return_code ;
int loop_counter ;


if (argc<4)
  {
  fprintf(stderr, "usage: %s PATH  VME_BASE_ADDR  NO_OF_LWORDS [LOOP_COUNTER]  \n", argv[0]);
  return 1;
  }

if ((p=open(argv[1], O_RDWR, 0))<0) {
     printf("no device \n"); 
     	return 1;
}

/* open VME */
/*
   if ((p=open("/tmp/sis1100", O_RDWR, 0))<0) {
     printf("error on opening VME environment\n");
     return -1;
   }
*/
mod_base     = strtoul(argv[2],NULL,0) ;
no_of_lwords = strtoul(argv[3],NULL,0) ;


loop_counter  = 1 ;
if (argc>4) loop_counter  = strtoul(argv[4],NULL,0) ;


if (no_of_lwords > MAX_NUMBER_LWORDS)
  {
     printf("no_of_lwords (0x%08x) must be lower then MAX_NUMBER_LWORDS (0x%08x)\n",no_of_lwords, MAX_NUMBER_LWORDS);
     return -1;
   }

#ifdef raus
for (i=0; i < 32; i++) {
   return_code =   vme_A32D32_write(p, mod_base+(4*i), i + ((i+i)<<16)) ;
 }
   return_code =   vme_A32D32_write(p, mod_base+(0),  0x11112222) ;
   return_code =   vme_A32D32_write(p, mod_base+(4),  0x33334444) ;
   return_code =   vme_A32D32_write(p, mod_base+(8),  0x55556666) ;
   return_code =   vme_A32D32_write(p, mod_base+(0xc),  0x77778888) ;
#endif
  
for (i=0; i < loop_counter; i++) {
   return_code =   vme_A24DMA_D16_read(p, mod_base, blt_data, no_of_lwords, &get_lwords) ;
 }



   printf("vme_A24DMA_D16_read:   return_code = 0x%08x\n", return_code );
   printf("vme_A24DMA_D16_read:   get_lwords  = 0x%08x\n", get_lwords );

   for (i=0;(i)<get_lwords;i++)
    {
      printf("i = 0x%08x     Data = 0x%08x\n",i, blt_data[i]);
    }




close(p);
return 0;
}



int vme_A24DMA_D16_read(int p, u_int32_t vme_adr, u_int32_t* vme_data,
                      u_int32_t req_num_of_lwords, u_int32_t* got_num_of_lwords)
{
struct sis1100_vme_block_req block_req;

   block_req.num=req_num_of_lwords   ; /*  */
   block_req.fifo=0;
   block_req.size=2;
   block_req.am=0x39;
   block_req.addr=vme_adr ;
   block_req.data = vme_data ;

   if (ioctl(p, SIS3100_VME_BLOCK_READ, &block_req)<0)  return -1 ;   /* NEW */
   *got_num_of_lwords = block_req.num;
   return block_req.error ;            /* NEW */
}


 






























