#define _GNU_SOURCE
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>


#include "../dev/pci/sis1100_var.h"  
#include "../sis3100_calls/sis3100_vme_calls.h"



/*
int soll_data ;
int max_lword_cnt ;
int loop_cnt ;
*/


/****************************************************************************/
int main(int argc, char* argv[])
{

#define MAX_NUMBER_LWORDS 0x100000  


int p_sharc;
int byte_offset;
int no_of_lwords ;


int i;

u_int32_t blt_data[MAX_NUMBER_LWORDS] ;
u_int32_t get_lwords ;
int return_code ;



if (argc<4)
  {
  fprintf(stderr, "usage: %s path (sis3100sharc)  SHARC_OFFSET    no_of_lwords \n", argv[0]);
  return 1;
  }



if ((p_sharc=open(argv[1], O_RDWR, 0))<0) {
	perror("open");
	return 1;
}



byte_offset  = strtoul(argv[2],NULL,0) ;
no_of_lwords = strtoul(argv[3],NULL,0) ;

if (no_of_lwords > MAX_NUMBER_LWORDS) 
  {
     printf("no_of_lwords (0x%08x) must be lower then MAX_NUMBER_LWORDS (0x%08x)\n",no_of_lwords, MAX_NUMBER_LWORDS);
     return 1;
   }

if ((byte_offset & 3) != 0) 
  {
     printf("SHARC_OFFSET has to be lword aligned (0x0, 0x4, 0x8 ...)\n");
     return 1;
   }

    return_code = s3100_sharc_read(p_sharc, byte_offset, blt_data, no_of_lwords) ;

   if (return_code < 0 )
     {
       printf("s3100_sharc_read:   return_code = 0x%08x\n", return_code );         
     }
    else
     {
       printf("s3100_sharc_read:   return_code = 0x%08x\n", return_code );         
       get_lwords = return_code >> 2 ;
       printf("s3100_sharc_read:   get_lwords  = 0x%08x\n", get_lwords ); 
       for (i=0;(i)<get_lwords;i++)
       {
         printf("i = 0x%08x     Data = 0x%08x\n",i, blt_data[i]);   
       }
     }




close(p_sharc);
return 0;
}





 































