/*
 * $ZEL$
 */

#include "test_3100.h"

int
vme_probe(struct path* path, u_int32_t addr)
{
    struct vmespace space;
    int res;

    space.am=0x9;
    space.datasize=4;
    space.swap=1;
    space.mapit=0;
    space.mindmalen=-1;
    res=ioctl(path->p, SIS1100_SETVMESPACE, &space);
    if (res) {
        printf("SETVMESPACE(%s): %s\n", path->name, strerror(errno));
        return -1;
    }
    res=ioctl(path->p, SIS3100_VME_PROBE, &addr);
    if (res) {
        printf("VME_PROBE(%s, 0x%08x): %s\n", path->name, addr, strerror(errno));
    }
    return res;
}
