
#ifndef PROCESSIO_H_SEEN
#define PROCESSIO_H_SEEN

#include <stdarg.h>
#include <errno.h>
#include <math.h>
#include <signal.h>
#include <string>

#define SERVER_NAME "Bias"       // Name to use in DIM
#include "Evidence.h"

#include "HVCalib.h"
#include "HV.h"
#include "../pixelmap/PixelMap.h"

#define MAX_COM_SIZE 5000
#define NUM_CHAINS 4
#define NUM_CHANNELS 32

#define MIN_TIMEOUT 0.01
#define MAX_TIMEOUT 5.0

#define MIN_RATE 0.01
#define MAX_RATE 50.0

typedef enum stateenum {active, stopped, na} state_enum;

class ProcessIO: public EvidenceServer {

	time_t StartTime;
	PixelMap *pm;
	DimCommand *Command;
	DimService *ConsoleOut;
	char *ConsoleText;

	void commandHandler();

 public:
	HVCalib     *calib;
	HVBoard **fHVBoard;

	char Prompt[MAX_COM_SIZE];
	std::vector<std::string> Parameter;

	// Configuration data
	float fTimeOut;
	float fStatusRefreshRate;
	int DACMin;
	int DACMax;
	float fHVCalibOffset;
	float fHVCalibSlope;
	unsigned int fHVMaxDiff;

	// Status variables  
	pthread_t HVMonitor;       // exit function sends signal to these threads
	pthread_mutex_t Mutex;

	int NumHVBoards;
	int FirstBoard;
	int LastBoard;
	state_enum   state;

	// Methods
	ProcessIO();
	~ProcessIO();

	void PrintMessage(const char *, ...);
	void CommandControl(char*);
	bool RampVoltage(unsigned int, int, int, int);
	void Monitor();
	void ResetBoard(int);
	void PrintBoardStatus(int);
	
	void cmd_board();	void cmd_hv();
	void cmd_status();	void cmd_config();
	void cmd_load();	void cmd_save();
	void cmd_exit();	void cmd_rate();
	void cmd_timeout();	void cmd_reset();
	void cmd_start();	void cmd_stop();
	void cmd_uptime();	void cmd_help();
};

bool Match(std::string, const char *);
bool ConvertToDouble(std::string, double *);
bool ConvertToInt(std::string, int *);

#endif
