#ifndef MARS_MHCT1Supercuts
#define MARS_MHCT1Supercuts

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class TH2F;

class MHCT1Supercuts : public MH
{
private:
    TH1F *fDegree;     // order of polynomial for background fit
    TH1F *fProb;       // chi2 probability of polynomial fit
    TH1F *fNdf;        // NDF of polynomial fit
    TH1F *fGamma;      // Nbg = gamma * Noff
    TH1F *fNexNon;     // no.of excess events / no.of events in signal region 
    TH1F *fSigLiMa;    // significance of gamma signal

    TH2F *fSigtoBackg; // significance vs signal to background ratio (Nex/Nbg)
    TH2F *fSigDegree;  // significance vs order of polynomial
    TH2F *fSigNbins;   // significance vs number of bins


public:
    MHCT1Supercuts(const char *name=NULL, const char *title=NULL);
    ~MHCT1Supercuts();

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    void Draw(Option_t *opt=NULL);


    ClassDef(MHCT1Supercuts, 1) // Container which holds histograms for the supercuts
};

#endif





