#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <sstream>
#include <iomanip>
#include <errno.h>
#include <vector>
#include <map>

#include <exception>
#include <cxxabi.h>

#include "dis.hxx"
#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available
#define EVIDENCE_REVISION "$Revision: 231 $"

// Class declation of Evidence server
class EvidenceServer: public DimServer {

	// Internal class for configuration requests
	class Config: public DimClient, public DimRpcInfo {

		pthread_mutex_t Mutex;
		std::string Name;
		DimInfo *Service;
		int ConfigTimeStamp;
		std::string CurrentItem;
		pthread_t ThreadID;

		struct Item {
		  std::string Value;
		  int Time;
		};
		std::map<std::string, struct Item> List;

	  public:
		Config(std::string);
		~Config();

		std::string GetConfig(std::string, std::string);
		void Lock();
		void Unlock();
		void infoHandler();
		void rpcInfoHandler();
	};

	struct Message {
      int Severity;
	  char Text[];
	};

	std::string Name;
    DimService *MessageService;
	struct Message *MessageData;
	class Config *ConfClass;
	static int ConfigSignal;		// static since accessed in signal handler

    static void SignalHandler(int); // static for signal()
    static void Terminate();  		// static for set_terminate()
	void errorHandler(int, int, char *);
	void exitHandler(int);
	virtual void ConfigChanged() {};

  public:
    EvidenceServer(const char *);
	~EvidenceServer();

	enum MessageType {INFO=0, WARN=1, ERROR=2, FATAL=3};

	void Message(MessageType, const char *, ...);
	void SendToLog(const char *, ...);
	std::string GetConfig(std::string, std::string = std::string());
	void ActivateSignal(int);
	static std::string ToString(DimInfo *);
	static bool ServiceOK(DimInfo *);
	static bool ServiceOK(DimRpcInfo *);
	static std::vector<std::string> Tokenize(const std::string &, const std::string & = " ");

    bool ExitRequest;
};

class EvidenceHistory {

  public:  
  	struct Item {
	  int Time;
	  int Size;
	  char Data[]; // Size bytes follow
	} __attribute__((packed));

	static const struct Item WrapMark;
	static const struct Item EndMark;

  private:
	std::string Name;
	char *Buffer;
	int BufferSize;
	char *DataStart;
	struct Item *Pointer;
	
  public:
	EvidenceHistory(std::string);
	~EvidenceHistory();	

	bool GetHistory();
	char *GetFormat();
	const struct Item *Next();
	void Rewind();
};
#endif
