#ifndef MARS_MDataChain
#define MARS_MDataChain

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MDataList                                                              //
//                                                                         //
//  List of several filters                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MData
#include "MData.h"
#endif

class MDataChain : public MData
{
private:
    MData *fMember; // Filter

    // PLEASE, always add new enums to the end of the enumeration,
    // otherwise you would break loading old data chains...
    typedef enum {
        kENoop,
        kELog, kELog2, kELog10,
        kEAbs,
        kESin, kECos, kETan, kESinH, kECosH, kETanH,
        kEASin, kEACos, kEATan, kEASinH, kEACosH, kEATanH,
        kESqrt, kESqr, kEPow10, kEExp,
        kESgn,
        kEPositive,
        kENegative,
        kEFloor, kECeil,
        kERad2Deg, kEDeg2Rad, kERandom,
        kERandomP, kERandomE, kERandomI, kERandomG, kERandomL,
        kEIsNaN, kEFinite
    } OperatorType_t;

    OperatorType_t fOperatorType;

    OperatorType_t ParseOperator(TString txt) const;

    Int_t IsAlNum(TString txt);
    Int_t GetBracket(TString txt, char open, char close);

    MData *ParseString(TString txt, Int_t level);
    MData *ParseDataMember(TString txt);

    MDataChain(const char *rule, OperatorType_t op);

public:
    MDataChain(const char *rule=NULL, const char *name=NULL, const char *title=NULL);
    ~MDataChain();

    Double_t GetValue() const;
    Bool_t PreProcess(const MParList *plist);

    Bool_t IsValid() const { return fMember ? kTRUE : kFALSE; }
    Bool_t IsReadyToSave() const;

//    void Print(Option_t *opt = "") const;

    TString GetRule() const;
    TString GetDataMember() const;

    ClassDef(MDataChain, 1) // A chain/concatenation of MData objects
};

#endif
