/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  5/2002 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  STAR - STandard Analysis and Reconstruction
//
//  This macro is the standard converter to convert raw data into image
//  parameters
//
/////////////////////////////////////////////////////////////////////////////

#include "MImgCleanStd.h"

void star(Float_t clean1=3., Float_t clean2=2.5)
{
    //
    // This is a demonstration program which calculates the image 
    // parameters from a Magic raw data root file.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;

    plist.AddToList(&tlist);

    MSrcPosCam src;
    src.SetReadyToSave();
    plist.AddToList(&src);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choose a wrong geometry by mistake
    //
    MGeomCamMagic geomcam;
    plist.AddToList(&geomcam);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    MReadMarsFile read("Events");
    read.DisableAutoScheme();

    // ------------- user change -----------------
    //    read.AddFile("Pro*.root");
    //    read.AddFile("Gamma_*_0_7_*.root");
    //    read.AddFile("Gamma_*.root");

    gSystem->Exec("ls Gamma_*.root > files.txt");

    Float_t ratio = 1.;

    ifstream list;
    list.open("files.txt");
    while (1)
      {
	Char_t file[256];
	list >> file;
	if (!list.good()) break;
	TChain dummy("Events");
	dummy.Add(file);
	Int_t maxevents = ratio*dummy.GetEntries();

	read.AddFile(file,maxevents);
      }
    list.close();
    gSystem->Exec("rm files.txt");
 
    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;

    MCerPhotCalc      ncalc;

    const Float_t x[15]={0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    const TArrayF w(15,(Float_t*)x);
    ncalc.SetWeights(w);

    MBlindPixelCalc   blind;
    blind.SetUseInterpolation();

    MImgCleanStd      clean(clean1, clean2);

    MHillasCalc       hcalc;
    MHillasSrcCalc    scalc; // !!Preliminary!! Will be removed later!


    MContinue filtersize300("MHillas.fSize<300");
    MContinue filtersize500("MHillas.fSize<500");
    MContinue filtersize1000("MHillas.fSize<1000");
    MContinue filtersize2000("MHillas.fSize<2000");

    MFEventSelector eventselector1;
    eventselector1.SetNumSelectEvts(10000);
    MFEventSelector eventselector2;
    eventselector2.SetNumSelectEvts(17000);
    MFEventSelector eventselector3;
    eventselector3.SetNumSelectEvts(27000);
    MFEventSelector eventselector4;
    eventselector4.SetNumSelectEvts(63000);
    MFEventSelector eventselector5;
    eventselector5.SetNumSelectEvts(150000);

    // ------------- user change -----------------


    Char_t dir[256];
    //    sprintf (dir, "Clean_%.1f_%.1f/", clean1, clean2);
    TString out = dir;

    out += "Sgt0/star_gammas.root";
    MWriteRootFile write1(out);
    write1.SetFilter(&eventselector1);
    write1.AddContainer("MRawRunHeader", "RunHeaders");
    write1.AddContainer("MMcRunHeader",  "RunHeaders");
    write1.AddContainer("MSrcPosCam",    "RunHeaders");
    write1.AddContainer("MMcEvt",        "Events");
    write1.AddContainer("MHillas",       "Events");
    write1.AddContainer("MHillasExt",    "Events");
    write1.AddContainer("MHillasSrc",    "Events");
    write1.AddContainer("MNewImagePar",  "Events");

    out = dir;
    out += "Sgt300/star_gammas.root";
    MWriteRootFile write2(out);
    write2.SetFilter(&eventselector2);
    write2.AddContainer("MRawRunHeader", "RunHeaders");
    write2.AddContainer("MMcRunHeader",  "RunHeaders");
    write2.AddContainer("MSrcPosCam",    "RunHeaders");
    write2.AddContainer("MMcEvt",        "Events");
    write2.AddContainer("MHillas",       "Events");
    write2.AddContainer("MHillasExt",    "Events");
    write2.AddContainer("MHillasSrc",    "Events");
    write2.AddContainer("MNewImagePar",  "Events");

    // Extra !
    write2.AddContainer("MMcTrigHeader", "RunHeaders");
    write2.AddContainer("MMcCorsikaRunHeader", "RunHeaders");
    write2.AddContainer("MMcFadcHeader",       "RunHeaders");
    write2.AddContainer("MMcTrig",       "Events");
    write2.AddContainer("MRawEvtData",   "Events");
    write2.AddContainer("MRawEvtHeader", "Events");

    out = dir;
    out += "Sgt500/star_gammas.root";
    MWriteRootFile write3(out);
    write3.SetFilter(&eventselector3);
    write3.AddContainer("MRawRunHeader", "RunHeaders");
    write3.AddContainer("MMcRunHeader",  "RunHeaders");
    write3.AddContainer("MSrcPosCam",    "RunHeaders");
    write3.AddContainer("MMcEvt",        "Events");
    write3.AddContainer("MHillas",       "Events");
    write3.AddContainer("MHillasExt",    "Events");
    write3.AddContainer("MHillasSrc",    "Events");
    write3.AddContainer("MNewImagePar",  "Events");

    out = dir;
    out += "Sgt1000/star_gammas.root";
    MWriteRootFile write4(out);
    write4.SetFilter(&eventselector4);
    write4.AddContainer("MRawRunHeader", "RunHeaders");
    write4.AddContainer("MMcRunHeader",  "RunHeaders");
    write4.AddContainer("MSrcPosCam",    "RunHeaders");
    write4.AddContainer("MMcEvt",        "Events");
    write4.AddContainer("MHillas",       "Events");
    write4.AddContainer("MHillasExt",    "Events");
    write4.AddContainer("MHillasSrc",    "Events");
    write4.AddContainer("MNewImagePar",  "Events");

    out = dir;
    out += "Sgt2000/star_gammas.root";
    MWriteRootFile write5(out);
    write5.SetFilter(&eventselector5);
    write5.AddContainer("MRawRunHeader", "RunHeaders");
    write5.AddContainer("MMcRunHeader",  "RunHeaders");
    write5.AddContainer("MSrcPosCam",    "RunHeaders");
    write5.AddContainer("MMcEvt",        "Events");
    write5.AddContainer("MHillas",       "Events");
    write5.AddContainer("MHillasExt",    "Events");
    write5.AddContainer("MHillasSrc",    "Events");
    write5.AddContainer("MNewImagePar",  "Events");

    tlist.AddToList(&read);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&clean);
    tlist.AddToList(&blind);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&scalc);

    tlist.AddToList(&eventselector1);
    tlist.AddToList(&write1);
    tlist.AddToList(&filtersize300);  //FILTER SIZE LINE

    tlist.AddToList(&eventselector2);
    tlist.AddToList(&write2);
    tlist.AddToList(&filtersize500);  //FILTER SIZE LINE

    tlist.AddToList(&eventselector3);
    tlist.AddToList(&write3);
    tlist.AddToList(&filtersize1000);  //FILTER SIZE LINE

    tlist.AddToList(&eventselector4);
    tlist.AddToList(&write4);
    tlist.AddToList(&filtersize2000);  //FILTER SIZE LINE

    tlist.AddToList(&eventselector5);
    tlist.AddToList(&write5);

    //
    // Create and set up the eventloop
    //
    MProgressBar bar;

    MEvtLoop evtloop;
    evtloop.SetProgressBar(&bar);
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
     //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();
}
