--
-- VHDL Architecture FACT_FAD_lib.spi_clock_generator.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 14:49:19 01.04.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

ENTITY FTU_test2_spi_clock_generator IS
   GENERIC( 
      CLK_DIVIDER : integer := 25   --2 MHz @ 50 MHz
   );
   PORT( 
      clk  : IN     std_logic;
      sclk : OUT    std_logic  := '0'
   );
END FTU_test2_spi_clock_generator;

ARCHITECTURE beha OF FTU_test2_spi_clock_generator IS
  
BEGIN
  
  spi_clk_proc: process (clk)
    variable Z: integer range 0 to clk_divider - 1;
  begin
    if rising_edge(clk) then
      if (Z < clk_divider - 1) then 
        Z := Z + 1;
      else 
        Z := 0;
      end if;
      if (Z = 0) then 
        sclk <= '1';
      end if;
      if (Z = clk_divider / 2) then 
        sclk <= '0';
      end if;
    end if;
  end process spi_clk_proc;

END ARCHITECTURE beha;
