----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
--
-- Create Date:    01/07/2010
-- Design Name:
-- Module Name:    FTU_test2_spi_interface - Behavioral
-- Project Name:
-- Target Devices:
-- Tool versions:
-- Description:    Based on VHDL Entity FACT_FAD_lib.spi_interface.symbol
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library ftu_definitions;
USE ftu_definitions.ftu_array_types.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

ENTITY FTU_test2_spi_interface IS
   PORT(
      clk_50MHz      : IN     std_logic;
      config_start   : IN     std_logic;
      dac_array      : IN     dac_array_type;
      config_ready   : OUT    std_logic;
      config_started : OUT    std_logic  := '0';
      dac_cs         : OUT    std_logic;
      mosi           : OUT    std_logic  := '0';
      sclk           : OUT    std_logic;
      miso           : INOUT  std_logic
   );
END FTU_test2_spi_interface;

ARCHITECTURE struct OF FTU_test2_spi_interface IS

   -- Internal signal declarations
   SIGNAL dac_config_ready : std_logic;
   SIGNAL dac_config_start : std_logic;
   SIGNAL dac_id           : std_logic_vector(2 DOWNTO 0);
   SIGNAL data             : std_logic_vector(15 DOWNTO 0);

   -- Implicit buffer signal declarations
   SIGNAL sclk_internal : std_logic;


   -- Component Declarations
   COMPONENT FTU_test2_spi_clock_generator
   GENERIC (
      CLK_DIVIDER : integer := 25      --2 MHz @ 50 MHz
   );
   PORT (
      clk  : IN     std_logic;
      sclk : OUT    std_logic  := '0'
   );
   END COMPONENT;
   
   COMPONENT FTU_test2_spi_controller
   PORT (
      clk          : IN     std_logic;
      dac_id       : IN     std_logic_vector (2 DOWNTO 0);
      dac_start    : IN     std_logic;
      dac_cs       : OUT    std_logic                      := '1';
      dac_ready    : OUT    std_logic                      := '0';
      mosi         : OUT    std_logic                      := '0';
      data         : INOUT  std_logic_vector (15 DOWNTO 0) := (others => 'Z');
      miso         : INOUT  std_logic                      := 'Z'
   );
   END COMPONENT;
   
   COMPONENT FTU_test2_spi_distributor
   PORT (
      clk               : IN     std_logic;
      config_start      : IN     std_logic;
      dac_array         : IN     dac_array_type;
      dac_config_ready  : IN     std_logic;
      config_ready      : OUT    std_logic                      := '0';
      config_started    : OUT    std_logic                      := '0';
      dac_config_start  : OUT    std_logic                      := '0';
      dac_id            : OUT    std_logic_vector (2 DOWNTO 0)  := (others => '0');
      data              : INOUT  std_logic_vector (15 DOWNTO 0) := (others => 'Z')
   );
   END COMPONENT;

BEGIN

   -- Instance port mappings.
   Inst_FTU_test2_spi_clock_generator : FTU_test2_spi_clock_generator
      GENERIC MAP (
         CLK_DIVIDER => 25         --2 MHz @ 50 MHz
      )
      PORT MAP (
         clk  => clk_50MHz,
         sclk => sclk_internal
      );
   
   Inst_FTU_test2_spi_controller : FTU_test2_spi_controller
      PORT MAP (
         clk          => sclk_internal,
         miso         => miso,
         mosi         => mosi,
         dac_id       => dac_id,
         data         => data,
         dac_cs       => dac_cs,
         dac_start    => dac_config_start,
         dac_ready    => dac_config_ready
      );
   
   Inst_FTU_test2_spi_distributor : FTU_test2_spi_distributor
      PORT MAP (
         clk               => sclk_internal,
         config_start      => config_start,
         config_ready      => config_ready,
         config_started    => config_started,
         dac_array         => dac_array,
         dac_config_start  => dac_config_start,
         dac_config_ready  => dac_config_ready,
         dac_id            => dac_id,
         data              => data
      );

   -- Implicit buffered output assignments
   sclk <= sclk_internal;

END struct;
