library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity FTU_test2_upcnt16 is
  port(
    full  : out STD_LOGIC;
    clr   : in STD_LOGIC;
    reset : in STD_Logic;
    clk   : in STD_LOGIC
  );

end FTU_test2_upcnt16;

architecture DEFINITION of upcnt16 is

  constant RESET_ACTIVE : std_logic := '0';
  constant Cnt_full     : Unsigned (15 DOWNTO 0) :="1111111111111111";

  signal q : Unsigned (15 DOWNTO 0);

begin
  
  process(clk, reset, clr)
  begin
    -- Clear output register
    if ((reset OR clr)='1') then      
      q <= (others => '0');	       
      -- On rising edge of clock count
    elsif (clk'event) and clk = '1' and (not(q = Cnt_full)) then
      q <= q + 1;
    end if;
  end process;
	 
  process(q)
  begin
    if (q = Cnt_full)	then
      full <= '1';
    else
      full <= '0';
    end if;
  end process;

end DEFINITION;
