#ifndef MARS_MReadSocket
#define MARS_MReadSocket

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif
#ifndef ROOT_TTime
#include <TTime.h>
#endif

#include <iostream>  // base classes for MReadSocket

class TSocket;
class TServerSocket;

class MReadSocket : public std::streambuf, public std::istream
{
private:
    char *fBuffer; //!

    int   fMtu;
    TTime fTimeout;

    TServerSocket  *fServSock;
    TSocket        *fRxSocket;

    int underflow();
    int sync();

public:
    MReadSocket(int port, int mtu=1500);
    MReadSocket(MReadSocket const& log) : istream((std::streambuf*)&log)
    {
    }
    ~MReadSocket();

    void SetTimeout(UInt_t millisec) { fTimeout = millisec; }

    ClassDef(MReadSocket, 0) // This is what we call 'The logging system'
};

#endif
