----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
-- 
-- Create Date:    06/07/2010 
-- Design Name:    
-- Module Name:    FTU_test3 - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    Test firmware for FTU board, test the spi lines										
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTU_test3 is
  port(
    -- global control 
    ext_clk   : IN  STD_LOGIC;                      -- external clock from FTU board
    --reset     : in  STD_LOGIC;                      -- reset
    --brd_add   : IN  STD_LOGIC_VECTOR(5 downto 0);   -- geographic board/slot address
    --brd_id    : IN  STD_LOGIC_VECTOR(7 downto 0);   -- local solder-programmable board ID
    
    -- rate counters LVDS inputs
    -- use IBUFDS differential input buffer
    --patch_A_p     : IN  STD_LOGIC;                  -- logic signal from first trigger patch
    --patch_A_n     : IN  STD_LOGIC;           
    --patch_B_p     : IN  STD_LOGIC;                  -- logic signal from second trigger patch
    --patch_B_n     : IN  STD_LOGIC;
    --patch_C_p     : IN  STD_LOGIC;                  -- logic signal from third trigger patch
    --patch_C_n     : IN  STD_LOGIC;
    --patch_D_p     : IN  STD_LOGIC;                  -- logic signal from fourth trigger patch
    --patch_D_n     : IN  STD_LOGIC;
    --trig_prim_p   : IN  STD_LOGIC;                  -- logic signal from n-out-of-4 circuit
    --trig_prim_n   : IN  STD_LOGIC;
    
    -- DAC interface
    -- miso          : IN  STD_LOGIC;                  -- master-in-slave-out
    sck           : OUT STD_LOGIC;                  -- serial clock to DAC
    mosi          : OUT STD_LOGIC;                  -- serial data to DAC, master-out-slave-in
    --clr           : OUT STD_LOGIC;                  -- clear signal to DAC
    cs_ld         : OUT STD_LOGIC                  -- chip select or load to DAC
    
    -- RS-485 interface to FTM
    --rx            : IN  STD_LOGIC;                  -- serial data from FTM
    --tx            : OUT STD_LOGIC;                  -- serial data to FTM
    --rx_en         : OUT STD_LOGIC;                  -- enable RS-485 receiver
    --tx_en         : OUT STD_LOGIC;                  -- enable RS-485 transmitter

    -- analog buffer enable
    --enables_A   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    --enables_B   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    --enables_C   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs
    --enables_D   : OUT STD_LOGIC_VECTOR(8 downto 0);  -- individual enables for analog inputs

    -- testpoints
    --TP_A       : out STD_LOGIC_VECTOR(11 downto 0)   -- testpoints    
  );
end FTU_test3;

architecture Behavioral of FTU_test3 is

  component FTU_test3_dcm
    port(
      CLKIN_IN        : IN  STD_LOGIC;
      CLKFX_OUT       : OUT STD_LOGIC;
      CLKIN_IBUFG_OUT : OUT STD_LOGIC
    );
  end component;

  signal ext_clk_sig: STD_LOGIC;
  signal clk_5M_sig : STD_LOGIC;
  
begin

  Inst_FTU_test3_dcm : FTU_test3_dcm
    port map(
      CLKIN_IN => ext_clk,
      CLKFX_OUT => clk_5M_sig,
      CLKIN_IBUFG_OUT => open
    );

  ext_clk_sig <= ext_clk;
  
  sck         <= ext_clk_sig;
  mosi        <= clk_5M_sig;
  cs_ld       <= clk_5M_sig;
  
end Behavioral;
