#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include <dev/pci/sis1100_var.h>

int main(int argc, char* argv[])
{
    int p;

    if (argc<2)
      {
      fprintf(stderr, "usage: %s path\n", argv[0]);
      return 1;
      }

    if ((p=open(argv[1], O_RDWR, 0))<0)
      {
      fprintf(stderr, "open(\"%s\"): %s\n", argv[1], strerror(errno));
      return 1;
      }
    
    if (ioctl(p, SIS1100_CLEAR_USE_COUNT)<0) {
	fprintf(stderr, "ioctl(SIS3100_CLEAR_USE_COUNT): %s\n",strerror(errno));
	return -1;
    }

    close(p);
    return 0;
}
