/*
 * $ZEL$
 */

#include "test_3100.h"

static void
print_ident(struct sis1100_ident_dev* ident)
{
    printf("  hw_type   =%2d ", ident->hw_type);
    switch (ident->hw_type) {
        case 1: printf(" (PCI/PLX)"); break;
        case 2: printf(" (VME)"); break;
        case 3: printf(" (CAMAC/FERA)"); break;
        case 4: printf(" (LVD/SCSI)"); break;
    }
    printf("\n");
    printf("  hw_version=%2d\n", ident->hw_version);
    printf("  fw_type   =%2d\n", ident->fw_type);
    printf("  fw_version=%2d\n", ident->fw_version);
}

int
check_IDENT(struct path* path)
{
    if (ioctl(path->p, SIS1100_IDENT, &path->ident)<0) {
        printf("ioctl(%s, SIS1100_IDENT): %s\n", path->name, strerror(errno));
        return -1;
    }
    switch (path->type) {
    case sis1100_subdev_remote:
        printf("Local Interface:\n");
        print_ident(&path->ident.local);
        if (path->ident.remote_ok) {
            printf("Remote Interface:\n");
            print_ident(&path->ident.remote);
            printf("  remote interface o%sline\n",
                    path->ident.remote_online?"n":"ff");
        } else
            printf("no remote interface\n");
        break;
#if MAJORVERSION >= 2
    case sis1100_subdev_ctrl: {
        u_int32_t val;
        if (path->map) {
            /* read first word */
            val=path->map[0];
            printf("subdev_ctrl: map[0]=0x%08x\n", val);
            path->map[0]=0x12345678;
            val=path->map[0];
            printf("subdev_ctrl: map[0]=0x%08x\n", val);
        }
        }
        break;
#endif
    }

    return 0;
}
