/*
 * $ZEL$
 */

#include "test_3100.h"

int
check_mmap(struct path* path)
{
#if SIS1100_Version < 0x20000
    if (path->type!=sis1100_subdev_remote) return 0;
#endif

    if (!path->mapsize) return 0;
    path->map=mmap(0, path->mapsize, PROT_READ|PROT_WRITE,
            MAP_FILE|MAP_SHARED/*|MAP_VARIABLE*/, path->p, 0);

    if (path->map==MAP_FAILED) {
        printf("mmap(%s, 0x%x): %s\n", path->name, path->mapsize,
            strerror(errno));
        path->map=0;
    } else
        printf("%s: 0x%x Bytes mapped at %p\n", path->name, path->mapsize,
            path->map);
 
    switch (path->type) {
    case sis1100_subdev_remote:
        if (!path->map)
            printf("  Not a real error.\n");
        else
            printf("  OK.\n");
        break;
    case sis1100_subdev_ram:
        if (!path->map)
            printf("  As expected.\n");
        else {
            printf("  But that is not possible (yet).\n");
            return -1;
        }
        break;
#if SIS1100_Version >= 0x20000
    case sis1100_subdev_ctrl:
        if (!path->map) {
            printf("  But it should work.\n");
            return -1;
        } else
            printf("  OK.\n");
        break;
#endif
    case sis1100_subdev_dsp:
        if (!path->map)
            printf("  OK.\n");
        else {
            printf("  But that is not possible (yet).\n");
            return -1;
        }
        break;
    default:
        printf("check_mmap: %s has unknown type %d\n",
                path->name, path->type);
        return -1;
    }
    return 0;
}
