/*
 * $ZEL$
 */

#include "test_3100.h"

int
check_reopen(struct path* path)
{
    int p;

    /* try to open the device a second time */
    p=open(path->name, O_RDWR, 0);
#if MAJORVERSION < 2
    if (p<0) {
        printf("open \"%s\" a second time: %s\n",
                path->name, strerror(errno));
        return -1;
    }
    close(p);
#else
    if (p>=0) {
        printf("open \"%s\" a second time: success (but it should fail)\n",
                path->name);
        close(p);
        return -1;
    }
    if (errno!=EBUSY) {
        printf("open \"%s\" a second time returns \"%s\" "
                "(but EBUSY is expected)\n",
                path->name, strerror(errno));
        return -1;
    }
#endif
    return 0;
}

