
#include "../header/sis3300.h"

int test1(int p, unsigned int vme_base_addr  ) ;


#define MAX_NUMBER_LWORDS 0x100000


int test1(int p, unsigned int vme_base_addr  )
{
unsigned int mod_base ;
int no_of_lwords ;

unsigned int addr ;
unsigned int data ;
unsigned int blt_data[MAX_NUMBER_LWORDS] ;
unsigned int get_lwords ;

int i;

int return_code ;
int error_cnt ;
int loop_cnt ;
int temp ;


mod_base = vme_base_addr ;





addr = mod_base + SIS3300_KEY_RESET ;                    /* reset */
return_code =  vme_A32D32_write(p, addr, 0x0) ;
if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


/* set bankfull output to Lemo Output 1 */
addr = mod_base + SIS3300_CONTROL_STATUS ;
data = 0x100;
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


addr = mod_base + SIS3300_START_DELAY ;
data = 0x0;
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }



addr = mod_base + SIS3300_ACQUISTION_CONTROL ; 	/* Acq. register */
data = 0x0 ;
/*data = 0x1000 ; 		          	  set 50 MHZ    */
data = data + 0x30  ;  				/* Enable Multievent and Autotstart and Enable Multibank Switch */
data = data + 0x4  ;  				/* Enable Multibank Switch */
data = data + 0x100 ;  				/* Enable LEMO Start/Stop */
/* data = data + 0x400 ;  				 Enable LEMO GATE mode */
/*data = data + 0x40 ;    Enable START_DELAY */

return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


/*data = 0xC ; 		Enable Wrap Around ; 128 Events each 1024 samples */
/* data = 0x4 ; 		  Autostop; 128 Events each 1024 samples */
 data = 0x0 ; 		 /* Autostop; 1 Events each 128k samples */

addr = mod_base + SIS3300_EVENT_CONFIG_ALL_ADC ;    /* Event configuration register all ADCs */
return_code =  vme_A32D32_write(p, addr, data) ;
if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


/* start Sampling in AUTO_BANK_SWITCH Mode */
addr = mod_base + SIS3300_KEY_START_AUTO_BANK_SWITCH ;
return_code =  vme_A32D32_write(p, addr, 0x0) ;
if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }


   printf("\n");
   printf("\n");

   loop_cnt = 0;
   error_cnt = 0 ;
   return_code = 0 ;

do {


  /* bank1 full check */
      addr = mod_base + SIS3300_ACQUISTION_CONTROL ;                    /* Acq. register */
      do {
         return_code =  vme_A32D32_read(p, addr, &data) ;
        /* return check */
      } while (((data & 0x200000) != 0x200000) && (return_code == 0x0)) ; /* wait until Bank1 Full Flag */
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr ); return -1 ; }


  /* read now all from Bank1 */
  /* read Event Directory Bank1 */
      addr = mod_base + SIS3300_EVENT_DIRECTORY_BANK1_ADC12 ;                    /*  Event Directory Bank1 */
      no_of_lwords = 0x80 ;
      return_code =   vme_A32BLT32_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords)  {
          printf("get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }

#ifdef tino

      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC12 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC34 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC56 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

      addr = mod_base + SIS3300_MEMBASE_BANK1_ADC78 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

   for (i=1;i<no_of_lwords;i++) {
     if ((blt_data[i] & 0x80000) == 0x0){
          printf("Error Bank1 Wrap bit is not set : i = 0x%08x   blt_data[i] = 0x%08x\n", i, blt_data[i] );
       }
/*
               if ((loop_cnt & 0x3FF) == 0x300 )   {
           printf(" i = 0x%08x   blt_data[i] = 0x%08x\n", i, blt_data[i] );
       }
*/
    /*          printf(" i = 0x%08x   blt_data[i] = 0x%08x\n", i, blt_data[i] ); */
   }
#endif

   /* clear BANK1_FULL_FLAG  --> free for sampling again */
   addr = mod_base + SIS3300_KEY_BANK1_FULL_FLAG ;
   return_code =  vme_A32D32_write(p, addr, 0x0) ;
   if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }




  /* bank2 full check */
      addr = mod_base + SIS3300_ACQUISTION_CONTROL ;                    /* Acq. register */
      do {
         return_code =  vme_A32D32_read(p, addr, &data) ;
        /* return check */
      } while (((data & 0x800000) != 0x800000) && (return_code == 0x0)) ; /* wait until Bank2 Full Flag */
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x  at address = 0x%08x\n", return_code, addr ); return -1 ; }


  /* read now all from Bank2 */
  /* read Event Directory Bank2 */
      addr = mod_base + SIS3300_EVENT_DIRECTORY_BANK2_ADC12 ;                    /*  Event Directory Bank1 */
      no_of_lwords = 0x80 ;
      return_code =   vme_A32BLT32_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;
      if (get_lwords != no_of_lwords)  {
          printf("get_lwords = 0x%08x\n", get_lwords );
          error_cnt = error_cnt + 1;
        }


#ifdef  tino
      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC12 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC34 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC56 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

      addr = mod_base + SIS3300_MEMBASE_BANK2_ADC78 ;      /*   */
      no_of_lwords = 0x20000 ;
      return_code =   vme_A32MBLT64_read(p, addr, blt_data, no_of_lwords, &get_lwords) ;

#endif

#ifdef tino

   for (i=1;i<no_of_lwords;i++) {
     if ((blt_data[i] & 0x80000) == 0x0){
          printf("Error Bank2 Wrap bit is not set : i = 0x%08x   blt_data[i] = 0x%08x\n", i, blt_data[i] );
       }

 /*          if ((loop_cnt & 0x3FF) == 0x100 )   {
           printf(" i = 0x%08x   blt_data[i] = 0x%08x\n", i, blt_data[i] );
       }
*/
    }
 #endif


   /* clear BANK2_FULL_FLAG  --> free for sampling again */
   addr = mod_base + SIS3300_KEY_BANK2_FULL_FLAG ;
   return_code =  vme_A32D32_write(p, addr, 0x0) ;
   if (return_code != 0) {printf("vme_A32D32_write: return_code = 0x%08x at address = 0x%08x\n",return_code,addr );return -1 ; }



   loop_cnt = loop_cnt + 1 ;
   if ((loop_cnt & 0xFF) == 0x0 )
   {
     printf(" \n");
     printf(" loop counter = 0x%08x \n", loop_cnt);
     printf(" \n");
   }



/* }while (0);  */
 }while (return_code == 0);


/*  *return_data = 0x0 ; */
  return 0 ;
}






























