#ifndef MARS_MCerPhotEvt
#define MARS_MCerPhotEvt

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif
#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif
#ifndef MARS_MCerPhotPix
#include "MCerPhotPix.h"
#endif

class MGeomCam;
class MCerPhotPix;

class MCerPhotEvt : public MCamEvent
{
private:
    UInt_t        fNumPixels;
    TArrayI       fLut;        // Lookup tabel to lookup pixel by index
    TClonesArray *fPixels;     //-> FIXME: Change TClonesArray away from a pointer?

public:
    MCerPhotEvt(const char *name=NULL, const char *title=NULL);
    ~MCerPhotEvt() { delete fPixels; }

    UInt_t GetNumPixels() const { return fNumPixels; }
    //void   InitSize(UInt_t num) { fPixels->Expand(num); }

    void   AddPixel(Int_t idx, Float_t nph, Float_t er)
    {
        //
        // If this is too slow or takes to much space we might use
        // MGeomApply and an InitSize member function instead.
        //
        if (idx>=fLut.GetSize())
            fLut.Set(idx+1);

        fLut[idx] = fNumPixels;
        new ((*fPixels)[fNumPixels++]) MCerPhotPix(idx, nph, er);
    }

    void FixSize();

    Bool_t  IsPixelExisting(Int_t id) const;
    Bool_t  IsPixelUsed    (Int_t id) const;
    Bool_t  IsPixelCore    (Int_t id) const;

    Float_t GetNumPhotonsMin(const MGeomCam *geom=NULL) const;
    Float_t GetNumPhotonsMax(const MGeomCam *geom=NULL) const;

    Float_t GetRatioMin(const MGeomCam *geom=NULL) const;
    Float_t GetRatioMax(const MGeomCam *geom=NULL) const;

    Float_t GetErrorPhotMin(const MGeomCam *geom=NULL) const;
    Float_t GetErrorPhotMax(const MGeomCam *geom=NULL) const;

    MCerPhotPix &operator[](int i)       { return *(MCerPhotPix*)(fPixels->UncheckedAt(i)); }
    MCerPhotPix &operator[](int i) const { return *(MCerPhotPix*)(fPixels->UncheckedAt(i)); }

    void Scale(Double_t f) { fPixels->ForEach(MCerPhotPix, Scale)(f); }
    void RemoveUnusedPixels();

    MCerPhotPix *GetPixById(int idx) const;// { return idx>=0 && idx<fLut.GetSize() ? (MCerPhotPix*)(fPixels->UncheckedAt(fLut[idx])) : 0; } // Return a pointer to the pixel with the requested id. NULL if it doesn't exist.

    void Reset();

    void Print(Option_t *opt=NULL) const;
    void Clear(Option_t *opt=NULL) { Reset(); }

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num, TVirtualPad *pad=NULL) const;

    ClassDef(MCerPhotEvt, 2)    // class for an event containing cerenkov photons
};

#endif
