#ifndef MARS_MHHillasSrc
#define MARS_MHHillasSrc

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class MHillas;

class MHHillasSrc : public MH
{
private:
    TH1F *fAlpha;     //->
    TH1F *fDist;      //->
    TH1F *fCosDA;     //->

    Float_t fMm2Deg;
    Bool_t  fUseMmScale;

public:
    MHHillasSrc(const char *name=NULL, const char *title=NULL);
    ~MHHillasSrc();

    void SetMmScale(Bool_t mmscale=kTRUE);
    void SetMm2Deg(Float_t mmdeg);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TH1 *GetHistByName(const TString name);

    TH1F *GetHistAlpha()         { return fAlpha; }
    TH1F *GetHistDist()          { return fDist; }
    TH1F *GetHistCosDeltaAlpha() { return fCosDA; }

    //void Draw(Option_t *opt=NULL);
    void DrawTS(TVirtualPad *pad=NULL, Option_t *opt=NULL);
    void Paint(Option_t *opt);


    ClassDef(MHHillasSrc, 1) // Container which holds histograms for the source dependant parameters
};

#endif
