/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!   Author(s): Harald Kornmayer 1/2001
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MCameraDisplay.h"

#include <TGButton.h>  // TGTextButton

#include "MGList.h"
#include "MEventDisplay.h"

ClassImp(MCameraDisplay)

enum {
    kButDisplay = 0x100
};

// --------------------------------------------------------------------------
//
//  Create the 'Data Check' GUI Controls (Window) on the screen. To use it
//  from within the interpreter you can call a Standard Version with
//  'new MCameraDisplay()'
//
MCameraDisplay::MCameraDisplay(/*const TGWindow *main,*/ const TGWindow *p,
                               const UInt_t w, const UInt_t h)
: MBrowser(/*main,*/ p, w, h)
{
    TGTextButton *disp = new TGTextButton(fTop2, "Display Events", kButDisplay);
    fList->Add(disp);

    disp->Associate(this);

    TGLayoutHints *laybut = new TGLayoutHints(kLHintsTop|kLHintsLeft, 10, 10, 5, 5);
    fList->Add(laybut);

    fTop2->AddFrame(disp, laybut);

    MapSubwindows();

    Layout();

    SetWindowName("Camera Display Window");
    SetIconName("Camera Dsiplay");

    MapWindow();
}

// --------------------------------------------------------------------------
//
//  Process the GUI control events (here: mainly button clicks)
//
Bool_t MCameraDisplay::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{
    // Process events generated by the buttons in the frame.

    if (GET_MSG(msg)!=kC_COMMAND || GET_SUBMSG(msg)!=kCM_BUTTON)
        return MBrowser::ProcessMessage(msg, parm1, parm2);

    switch (parm1)
    {
    case kButDisplay:
        if (!InputFileSelected())
        {
            DisplError("No Input (root) File selected!");
            return kTRUE;
        }

        switch (parm1)
        {
        case kButDisplay:
            new MEventDisplay(fInputFile);
            return kTRUE;
        }
        return kTRUE;
    }

    return MBrowser::ProcessMessage(msg, parm1, parm2);
}
