#ifndef VIEWEVENT_H_
#define VIEWEVENT_H_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include <arpa/inet.h>

void usage (char *argv);


typedef struct
{
	unsigned short start_package_flag;
	unsigned short package_length;
	unsigned short version_no;
	unsigned int trigger_id;
	unsigned char trigger_type;
	unsigned char trigger_crc;
	unsigned int local_trigger_id;
	unsigned char local_trigger_type;
	unsigned char local_trigger_crc;
	unsigned short board_id;
	short drs_temperature[4];
	unsigned short dac[8]; // new in version 0x0102
} __attribute__((__packed__))  EVNT_HEADER;

typedef struct
{
	unsigned short channel_id;
	unsigned short channel_start_cell;
	unsigned short channel_roi;
	unsigned short *channel_adc_data;
}  __attribute__((__packed__)) CHANNEL;

typedef struct
{
	EVNT_HEADER evnt_header;
	CHANNEL channel[4 * 9];
	unsigned short package_crc;		// new in version 0x0101
	unsigned short end_package_flag;
} EVNT;


#endif /*VIEWEVENT_H_*/
