#ifndef SOCKETCLIENT_H_
#define SOCKETCLIENT_H_

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>

#define MAX_COM_SIZE 32000
#define IP_ADDR_LENGTH 16
//#define IP_ADDR_DEFAULT "192.33.99.225"
#define IP_ADDR_DEFAULT "129.217.160.119"

#define FIRST_DAQPORT 5000

// Commands for FAD
#define CMD_Start 0xC000		// Start Run
#define CMD_Stop 0x3000			// Stop Run
#define CMD_Trigger 0xA000 		// single trigger
#define CMD_DENABLE 0x0600      // DENABLE line HIGH
#define CMD_DDISABLE 0x0700     // DENABLE line LOW
#define CMD_DWRITE_RUN 0x0800   // DWRITE possibly HIGH
#define CMD_DWRITE_STOP 0x0900  // DWRITE always LOW
#define CMD_Trigger_C 0xB000 	// continous trigger
#define CMD_Trigger_S 0x2000 	// stop continous trigger
#define CMD_Read 0x0A00 		// read from Config-RAM
#define CMD_Write 0x0500 		// write to Config-RAM

// Addresses in FAD Config-RAM
#define MAX_ADDR 0xFF // highest address in Config-RAM
#define BADDR_ROI 0x00 // Baseaddress ROI-Values
#define BADDR_DAC 0x24 // Baseaddress DAC-Values

// Max-Values
#define MAX_VAL 65535
#define MAX_ROINUM 35
#define MAX_ROIVAL 1024
#define MAX_DACNUM 7
#define MAX_DACVAL 65535

void cmd_send (char* Buffer, int Socket); // Send commands to socket
void int_handler (int sig); // Handle signal SIGINT (CTRL-C)
void exit_program (int exit_status); // Cleanup and exit

#endif /*SOCKETCLIENT_H_*/
