/***********************************************************************************/
/*                                                                                 */
/*   sis330x Register test 1                                                       */
/*   key reset                                                                     */
/*   1. check all default register values after reset                              */
/*   2. test each register by writing and reading                                  */
/*   3. test all "ALL_ADC" groups registers                                        */
/*   4. test all registers by writing to each register different values and read   */
/*                                                                                 */
/***********************************************************************************/

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include "dev/pci/sis1100_var.h"
#include "sis3100_vme_calls.h"

#include "../header/sis3300.h"



/*===========================================================================*/
/* Globals					  			     */
/*===========================================================================*/

#define MAX_NUMBER_OF_PRINTS 0x20

u_int32_t test1_data[16] ;


/*===========================================================================*/
/* Prototypes					  			     */
/*===========================================================================*/

int check_register_default_values(int ip, u_int32_t vme_addr, u_int32_t id_value)  ;

int sis330x_register_test(int ip, u_int32_t vme_addr, u_int32_t id_value) ;
int vme_D_register_test(int ip, u_int32_t vme_addr, u_int32_t mask_32bit)    ;
int vme_D_all_register_test(int p, u_int32_t vme_addr, u_int32_t mask_32bit) ;
int check_register_addresses(int p, u_int32_t vme_addr)  ;


/****************************************************************************/
int main(int argc, char* argv[])
{

int p;
u_int32_t mod_base ;
u_int32_t addr, data ;
u_int32_t id_value ;

int return_code ;


test1_data[0]   =   0x12345678 ;
test1_data[1]   =   0x87654321 ;
test1_data[2]   =   0x11224488 ;
test1_data[3]   =   0x88442211 ;
test1_data[4]   =   0xAA559966 ;
test1_data[5]   =   0x66AA5599 ;
test1_data[6]   =   0x9966AA55 ;
test1_data[7]   =   0x559966AA ;
test1_data[8]   =   0xffffffff ;
test1_data[9]   =   0x00000000 ;
test1_data[10]  =   0xFF00FF00 ;
test1_data[11]  =   0x00FF00FF ;
test1_data[12]  =   0xFFFF0000 ;
test1_data[13]  =   0x0000FFFF ;
test1_data[14]  =   0xF0F0F0F0 ;
test1_data[15]  =   0x0F0F0F0F ;

/* open VME */
   if ((p=open("/tmp/sis1100", O_RDWR, 0))<0) {
     printf("error on opening VME environment\n");
     return -1;
   }

if (argc<2)
  {
   printf("usage:  VME_BASE_ADDRESS of SIS3300/SIS3301    \n");
  return -1;
  }

mod_base  = strtoul(argv[1],NULL,0);



/******************************************************************/
/*                                                                */
/* SIS3300/SIS3301    register Test                               */
/*                                                                */
/******************************************************************/

addr = mod_base + SIS3300_MODID ;                    /* ID */
return_code =  vme_A32D32_read(p, addr, &data ) ;
if (return_code != 0) { printf("vme_A32D32_read: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}



if ((data == 0x33000302) || (data == 0x33010302)) {
      id_value = data  ;
     }
    else  {
      printf("wrong ID or Version (must be Version 0x301) \n");
      printf(" Modul Identification register:  0x%08x\n", data );
      return -1  ;
     }


/* reset */
addr = mod_base + SIS3300_KEY_RESET ;
return_code =  vme_A32D32_write(p, addr, 0x0) ;
if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
addr = mod_base  ;                    /* module base address */
return_code = check_register_default_values(p, addr, id_value)  ;
if (return_code != 0) {
      printf("Error: register default values after Key Reset \n");
      return -1 ;
    }
   else {
    printf("Register value after Key Reset                                                   OK\n");
    }


addr = mod_base  ;                    /* module base address */
return_code = sis330x_register_test(p, addr, id_value)  ;
if (return_code != 0) {
      printf("Error: sis330x register  \n");
      return -1 ;
    }
   else {
    printf("sis330x register test                                                            OK\n");
    }


addr = mod_base  ;                    /* module base address */
return_code = check_register_addresses(p, addr)  ;
if (return_code != 0) {
      printf("Error:   \n");
      return -1 ;
    }
   else {
    printf("sis330x check_register_addresses                                                 OK\n");
    }


/* second reset */
addr = mod_base + SIS3300_KEY_RESET ;
return_code =  vme_A32D32_write(p, addr, 0x0) ;
if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
addr = mod_base  ;                    /* module base address */
return_code = check_register_default_values(p, addr, id_value)  ;
if (return_code != 0) {
      printf("Error: register default values after second Key Reset \n");
      return -1 ;
    }
   else {
    printf("Register value after second Key Reset                                            OK\n");
    }



addr = mod_base  ;                    /* module base address */
return_code = sis330x_register_test(p, addr, id_value)  ;
if (return_code != 0) {
      printf("Error: sis330x register  \n");
      return -1 ;
    }
   else {
    printf("sis330x second register test                                                     OK\n");
    }


addr = mod_base  ;                    /* module base address */
return_code = check_register_addresses(p, addr)  ;
if (return_code != 0) {
      printf("Error:   \n");
      return -1 ;
    }
   else {
    printf("sis330x second check_register_addresses                                          OK\n");
    }


/* second reset */
addr = mod_base + SIS3300_KEY_RESET ;
return_code =  vme_A32D32_write(p, addr, 0x0) ;
if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
addr = mod_base  ;                    /* module base address */
return_code = check_register_default_values(p, addr, id_value)  ;
if (return_code != 0) {
      printf("Error: register default values after third Key Reset \n");
      return -1 ;
    }
   else {
    printf("Register value after third Key Reset                                             OK\n");
    }










close(p);
return 0 ;
}






/*************************************************************************************************************************/



int check_register_default_values(int p, u_int32_t vme_addr, u_int32_t id_value)
{

   u_int32_t addr, read_data ;
   u_int32_t default_data ;
   int error_cnt ;
   int return_code ;

   error_cnt = 0 ;
   addr = vme_addr + SIS3300_CONTROL_STATUS ;
   default_data =    SIS3300_DEFAULT_STATUS ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
      printf(" Error:default values after reset: addr = 0x%08x  default_data = 0x%08x  read = 0x%08x\n",addr,default_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   addr = vme_addr + SIS3300_IRQ_CONFIG         ;
   default_data =    SIS3300_DEFAULT_IRQ_CONFIG ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   addr = vme_addr + SIS3300_IRQ_CONTROL          ;
   default_data =    SIS3300_DEFAULT_IRQ_CONTROL    ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }


   addr = vme_addr + SIS3300_ACQUISTION_CONTROL         ;
   default_data =    SIS3300_DEFAULT_ACQ_CONTROL   ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
         printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }


   addr = vme_addr + SIS3300_START_DELAY         ;
   default_data =    SIS3300_DEFAULT_START_DELAY  ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }


   addr = vme_addr + SIS3300_STOP_DELAY          ;
   default_data =  SIS3300_DEFAULT_STOP_DELAY    ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }



   addr = vme_addr +  SIS3300_TIMESTAMP_PREDIVIDER         ;
   default_data =    SIS3300_DEFAULT_TIMEST_PREDI  ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf("Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data,read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }




   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC12         ;
   default_data =  SIS3300_DEFAULT_EVENT_CONFIG_ADC12    ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }


   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC34         ;
   default_data =  SIS3300_DEFAULT_EVENT_CONFIG_ADC34    ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }

   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC56         ;
   default_data =  SIS3300_DEFAULT_EVENT_CONFIG_ADC56    ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }

   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC78         ;
   default_data =  SIS3300_DEFAULT_EVENT_CONFIG_ADC78    ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }


   if ((id_value & 0xFFFF0000) == 0x33000000) {
                                         default_data =  SIS3300_DEFAULT_TRIG_THRESHOLD   ;
                                     }
                                     else  {
                                         default_data =  SIS3301_DEFAULT_TRIG_THRESHOLD     ;
                                     }

   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC12          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }

   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC34          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }

   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC56          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }

   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC78          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (read_data != (default_data)) {
          printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
          error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }



   default_data =  SIS3300_DEFAULT_TRIG_FLAG_CLR_CNT     ;
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC12          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC34          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC56          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC78          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }






   default_data =  SIS3300_DEFAULT_CLOCK_PREDIVIDER    ;
   addr = vme_addr +  SIS3300_CLOCK_PREDIVIDER_ADC12         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_CLOCK_PREDIVIDER_ADC34          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_CLOCK_PREDIVIDER_ADC56          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +  SIS3300_CLOCK_PREDIVIDER_ADC78         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }




   default_data =   SIS3300_DEFAULT_NO_OF_SAMPLE   ;
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC12         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC34         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC56         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC78         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }




   default_data =   SIS3300_DEFAULT_TRIGGER_SETUP   ;
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC12         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC34         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC56         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC78         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }



   default_data =   SIS3300_DEFAULT_MAX_NO_OF_EVENTS   ;
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC12          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC34          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC56          ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC78         ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }







   default_data =  SIS3300_DEFAULT_TRIGGER_SETUP    ;
   addr = vme_addr + SIS3300_TRIGGER_SETUP_ADC12           ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_TRIGGER_SETUP_ADC34           ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_TRIGGER_SETUP_ADC56           ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr + SIS3300_TRIGGER_SETUP_ADC78           ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }



   default_data =    SIS3300_DEFAULT_MAX_NO_OF_EVENTS  ;
   addr = vme_addr +   SIS3300_MAX_NO_OF_EVENTS_ADC12        ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +   SIS3300_MAX_NO_OF_EVENTS_ADC34        ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +   SIS3300_MAX_NO_OF_EVENTS_ADC56        ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }
   addr = vme_addr +   SIS3300_MAX_NO_OF_EVENTS_ADC78        ;
   return_code =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data != (default_data)) {
       printf(" Error:default values after reset at addr = 0x%08x  default_data = 0x%08x   read = 0x%08x\n",addr,default_data, read_data);
       error_cnt = error_cnt + 1;
       if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }



  if (error_cnt == 0) {
     return 0 ; }
    else {
     return -1 ;}
}














/*************************************************************************************************************************/

int sis330x_register_test(int p, u_int32_t mod_base, u_int32_t id_value)
{

   u_int32_t addr;
   u_int32_t   test_bit32_mask ;
   int error_cnt ;

   error_cnt =  0 ;

  addr = mod_base +  SIS3300_IRQ_CONFIG ;
  test_bit32_mask = 0x1fff ; /* onlx 12 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;




  addr = mod_base + SIS3300_START_DELAY  ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_STOP_DELAY  ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_TIMESTAMP_PREDIVIDER ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;


  addr = mod_base +  SIS3300_EVENT_CONFIG_ADC12 ;
  test_bit32_mask = 0xfeCff ; /* only 17 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_EVENT_CONFIG_ADC34 ;
  test_bit32_mask = 0xfeCff ; /* only 17 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_EVENT_CONFIG_ADC56 ;
  test_bit32_mask = 0xfeCff ; /* only 17 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_EVENT_CONFIG_ADC78 ;
  test_bit32_mask = 0xfeCff ; /* only 17 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;


  if ((id_value & 0xFFFF0000) == 0x33000000) test_bit32_mask =  0xfff ; /* only 12 bits */
                                     else    test_bit32_mask = 0x3fff ; /* only 14 bits */

  addr = mod_base +   SIS3300_TRIGGER_THRESHOLD_ADC12  ;
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +   SIS3300_TRIGGER_THRESHOLD_ADC34  ;
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +   SIS3300_TRIGGER_THRESHOLD_ADC56  ;
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +   SIS3300_TRIGGER_THRESHOLD_ADC78  ;
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;



  addr = mod_base +  SIS3300_TRIGGER_FLAG_CLR_CNT_ADC12 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_TRIGGER_FLAG_CLR_CNT_ADC34 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_TRIGGER_FLAG_CLR_CNT_ADC56 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_TRIGGER_FLAG_CLR_CNT_ADC78 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;


  addr = mod_base + SIS3300_CLOCK_PREDIVIDER_ADC12  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_CLOCK_PREDIVIDER_ADC34  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_CLOCK_PREDIVIDER_ADC56  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_CLOCK_PREDIVIDER_ADC78  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;



  addr = mod_base + SIS3300_NO_OF_SAMPLE_ADC12  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_NO_OF_SAMPLE_ADC34  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_NO_OF_SAMPLE_ADC56  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_NO_OF_SAMPLE_ADC78  ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;




  addr = mod_base + SIS3300_TRIGGER_SETUP_ADC12   ;
  test_bit32_mask = 0x110f0f0f ; /* only x bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_TRIGGER_SETUP_ADC34   ;
  test_bit32_mask = 0x110f0f0f ; /* only x bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_TRIGGER_SETUP_ADC56   ;
  test_bit32_mask = 0x110f0f0f ; /* only x bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base + SIS3300_TRIGGER_SETUP_ADC78   ;
  test_bit32_mask = 0x110f0f0f ; /* only x bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;


  addr = mod_base +  SIS3300_MAX_NO_OF_EVENTS_ADC12 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_MAX_NO_OF_EVENTS_ADC34 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_MAX_NO_OF_EVENTS_ADC56 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_MAX_NO_OF_EVENTS_ADC78 ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;




/* test all adc register address */
  addr = mod_base +  SIS3300_EVENT_CONFIG_ALL_ADC ;
  test_bit32_mask = 0xfeCff ; /* only 17 bits */
  if (vme_D_all_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  if ((id_value & 0xFFFF0000) == 0x33000000) test_bit32_mask =  0xfff ; /* only 12 bits */
                                     else    test_bit32_mask = 0x3fff ; /* only 14 bits */
  addr = mod_base +  SIS3300_TRIGGER_THRESHOLD_ALL_ADC   ;
  if (vme_D_all_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_TRIGGER_FLAG_CLR_CNT_ALL_ADC ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_all_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_CLOCK_PREDIVIDER_ALL_ADC ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_all_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_NO_OF_SAMPLE_ALL_ADC ;
  test_bit32_mask = 0xff ; /* only 8 bits */
  if (vme_D_all_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;



  addr = mod_base +  SIS3300_TRIGGER_SETUP_ALL_ADC  ;
  test_bit32_mask = 0x110f0f0f ; /* only x bits */
  if (vme_D_all_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;

  addr = mod_base +  SIS3300_MAX_NO_OF_EVENTS_ALL_ADC ;
  test_bit32_mask = 0xffff ; /* only 16 bits */
  if (vme_D_all_register_test(p, addr, test_bit32_mask) != 0x0) return -1  ;


  return 0 ;
}

















/*************************************************************************************************************************/

int vme_D_register_test(int p, u_int32_t vme_addr, u_int32_t mask_32bit)
{

   u_int32_t addr, data, read_data ;

   int i;
   int error_cnt ;
   int return_code ;


   addr =  vme_addr ;
   error_cnt =  0 ;

   if ((addr & 0xffffff) == SIS3300_EVENT_CONFIG_ALL_ADC)  printf("addr = 0x%08x\n",addr);

/******************************************************************/
/*                                                                */
/* step 1:   bit shift pattern                                    */
/*                                                                */
/******************************************************************/
   for (i=0;i<32;i++)  {
      data = (0x1 << (i&0x1f))   & mask_32bit  ;
   /* write */
      return_code =  vme_A32D32_write(p, addr, data) ;
      if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   /* read */
      return_code =  vme_A32D32_read(p, addr, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }

/******************************************************************/
/*                                                                */
/* step 2:    pattern                                             */
/*                                                                */
/******************************************************************/

   for (i=0;i<32;i++)  {
      data = (test1_data[i&0xf] & mask_32bit);
   /* write */
      return_code =  vme_A32D32_write(p, addr, data) ;
      if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* read */
      return_code =  vme_A32D32_read(p, addr, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }


/******************************************************************/
/*                                                                */
/* step 3:    random                                              */
/*                                                                */
/******************************************************************/

   for (i=0;i<0x1000;i++)  {
      data = random() & mask_32bit ;
   /* write */
      return_code =  vme_A32D32_write(p, addr, data) ;
      if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* read */
      return_code =  vme_A32D32_read(p, addr, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
           }
       }



  if (error_cnt == 0) {
     return 0 ; }
    else {
     return -1 ;}
}





/*************************************************************************************************************************/
/* special test for the SIS330x   xxxxx_ADC_ALL registers                                                                */
/* vme_addr has to be the _ALL_ADC address                                                                               */

int vme_D_all_register_test(int p, u_int32_t vme_addr, u_int32_t mask_32bit)
{

   u_int32_t addr, data, read_data ;
   u_int32_t addr12, addr34, addr56, addr78  ;

   int i;
   int error_cnt ;
   int return_code ;


   addr     =  vme_addr ;
   addr12   =  vme_addr +  0x100000 ;
   addr34   =  vme_addr +  0x180000  ;
   addr56   =  vme_addr +  0x200000  ;
   addr78   =  vme_addr +  0x280000  ;

   error_cnt =  0 ;

/******************************************************************/
/*                                                                */
/* step 1:   bit shift pattern                                    */
/*                                                                */
/******************************************************************/
   for (i=0;i<32;i++)  {
      data = (0x1 << (i&0x1f))   & mask_32bit  ;
   /* write */
      return_code =  vme_A32D32_write(p, addr, data) ;
      if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   /* read from addr12*/
      return_code =  vme_A32D32_read(p, addr12, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr12);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr12, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr34 */
      return_code =  vme_A32D32_read(p, addr34, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr34);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr34, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr56 */
      return_code =  vme_A32D32_read(p, addr34, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr56);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr56, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr78 */
      return_code =  vme_A32D32_read(p, addr78, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr78);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr78, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
    }

/******************************************************************/
/*                                                                */
/* step 2:    pattern                                             */
/*                                                                */
/******************************************************************/

   for (i=0;i<32;i++)  {
      data = (test1_data[i&0xf] & mask_32bit);
   /* write */
      return_code =  vme_A32D32_write(p, addr, data) ;
      if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* read from addr12*/
      return_code =  vme_A32D32_read(p, addr12, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr12);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr12, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr34 */
      return_code =  vme_A32D32_read(p, addr34, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr34);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr34, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr56 */
      return_code =  vme_A32D32_read(p, addr34, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr56);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr56, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr78 */
      return_code =  vme_A32D32_read(p, addr78, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr78);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr78, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
    }

/******************************************************************/
/*                                                                */
/* step 3:    random                                              */
/*                                                                */
/******************************************************************/

   for (i=0;i<0x1000;i++)  {
      data = random() & mask_32bit ;
   /* write */
      return_code =  vme_A32D32_write(p, addr, data) ;
      if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   /* read from addr12*/
      return_code =  vme_A32D32_read(p, addr12, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr12);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr12, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr34 */
      return_code =  vme_A32D32_read(p, addr34, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr34);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr34, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr56 */
      return_code =  vme_A32D32_read(p, addr34, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr56);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr56, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
   /* read from addr78 */
      return_code =  vme_A32D32_read(p, addr78, &read_data) ;
      if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr78);return -1;}
   /* check */
      if (data != (read_data & mask_32bit)) {
          printf(" Error at i = : 0x%04x  addr = 0x%08x  written = 0x%08x   read = 0x%08x\n", i, addr78, data, read_data);
             error_cnt = error_cnt + 1;
             if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
       }
    }


  if (error_cnt == 0) {
     return 0 ; }
    else {
     return -1 ;}
}





/*************************************************************************************************************************/
/* write to each register different values                                                                               */


int check_register_addresses(int p, u_int32_t vme_addr)
{
   u_int32_t addr, read_data ;
   u_int32_t test_data ;
   int error_cnt ;
   int return_code ;

   error_cnt = 0 ;

 /* write test_datas to all register */

   test_data = 0x1 ; /* SIS3300_CONTROL_STATUS */
   addr = vme_addr + SIS3300_CONTROL_STATUS ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}



   test_data = 0x2 ;  /* SIS3300_IRQ_CONTROL */
   addr = vme_addr + SIS3300_IRQ_CONTROL ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x3 ; /* SIS3300_IRQ_CONFIG */
   addr = vme_addr + SIS3300_IRQ_CONFIG ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}


   test_data = 0x8  ; /*  */
   addr = vme_addr + SIS3300_ACQUISTION_CONTROL         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x9  ; /*  */
   addr = vme_addr + SIS3300_START_DELAY         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0xA  ; /*  */
   addr = vme_addr + SIS3300_STOP_DELAY          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}


   test_data = 0xB  ; /*  */
   addr = vme_addr +  SIS3300_TIMESTAMP_PREDIVIDER         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}



   test_data = 0xC   ; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC12         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0xD   ; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC34         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0xE  ; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC56         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0xF   ; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC78         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}



   test_data = 0x10  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC12          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x11  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC34          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x12  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC56          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x13  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC78          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}



   test_data = 0x14  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC12          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x15  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC34          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x16  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC56          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x17  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC78          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}


   test_data = 0x18  ; /*  */
   addr = vme_addr +  SIS3300_CLOCK_PREDIVIDER_ADC12         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x19  ; /*  */
   addr = vme_addr + SIS3300_CLOCK_PREDIVIDER_ADC34          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x1A  ; /*  */
   addr = vme_addr + SIS3300_CLOCK_PREDIVIDER_ADC56          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x1B  ; /*  */
   addr = vme_addr +  SIS3300_CLOCK_PREDIVIDER_ADC78         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}


   test_data = 0x1C  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC12         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x1D  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC34         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x1E  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC56         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x1F  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC78         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}



   test_data = 0x200  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC12         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x201  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC34         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x202  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC56         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x203  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC78         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}




   test_data = 0x24  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC12          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x25  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC34          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x26  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC56          ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}

   test_data = 0x27  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC78         ;
   return_code =  vme_A32D32_write(p, addr, test_data) ;
   if (return_code != 0) { printf("vme_A32D32_write: return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}






 /* read and test_datas from all register */
   test_data = 0x1 ;
   addr = vme_addr + SIS3300_CONTROL_STATUS ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   test_data = 0x2 ;  /* SIS3300_IRQ_CONTROL */
   addr = vme_addr + SIS3300_IRQ_CONTROL ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   test_data = 0x3 ; /* SIS3300_IRQ_CONFIG */
   addr = vme_addr + SIS3300_IRQ_CONFIG ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }



   test_data = 0x8  ; /*  */
   addr = vme_addr + SIS3300_ACQUISTION_CONTROL         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   test_data = 0x9  ; /*  */
   addr = vme_addr + SIS3300_START_DELAY         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }








   test_data = 0xA  ; /*  */
   addr = vme_addr + SIS3300_STOP_DELAY          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0xB  ; /*  */
   addr = vme_addr +  SIS3300_TIMESTAMP_PREDIVIDER         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   test_data = 0xC + SIS3300_DEFAULT_EVENT_CONFIG_ADC12 ; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC12         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0xD + SIS3300_DEFAULT_EVENT_CONFIG_ADC34 ; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC34         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0xE + SIS3300_DEFAULT_EVENT_CONFIG_ADC56; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC56         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0xF + SIS3300_DEFAULT_EVENT_CONFIG_ADC78 ; /*  */
   addr = vme_addr +  SIS3300_EVENT_CONFIG_ADC78         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }




   test_data = 0x10  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC12          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x11  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC34          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x12  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC56          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x13  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_THRESHOLD_ADC78          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }





   test_data = 0x14  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC12          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x15  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC34          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x16  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC56          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x17  ; /*  */
   addr = vme_addr + SIS3300_TRIGGER_FLAG_CLR_CNT_ADC78          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }




   test_data = 0x18  ; /*  */
   addr = vme_addr +  SIS3300_CLOCK_PREDIVIDER_ADC12         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x19  ; /*  */
   addr = vme_addr + SIS3300_CLOCK_PREDIVIDER_ADC34          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x1A  ; /*  */
   addr = vme_addr + SIS3300_CLOCK_PREDIVIDER_ADC56          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x1B  ; /*  */
   addr = vme_addr +  SIS3300_CLOCK_PREDIVIDER_ADC78         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }





   test_data = 0x1C  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC12         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x1D  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC34         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x1E  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC56         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x1F  ; /*  */
   addr = vme_addr +  SIS3300_NO_OF_SAMPLE_ADC78         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   test_data = 0x200  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC12         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x201  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC34         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x202  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC56         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x203  ; /*  */
   addr = vme_addr +  SIS3300_TRIGGER_SETUP_ADC78         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }


   test_data = 0x24  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC12          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x25  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC34          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x26  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC56          ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }

   test_data = 0x27  ; /*  */
   addr = vme_addr + SIS3300_MAX_NO_OF_EVENTS_ADC78         ;
   return_code  =  vme_A32D32_read(p, addr, &read_data) ;
   if (return_code != 0) { printf("vme_A32D32_read:  return_code = 0x%08x at addr = 0x%08x\n",return_code,addr);return -1;}
   /* check */
   if (read_data !=  test_data) {
      printf(" Error check_register_addresses: addr = 0x%08x  test_data = 0x%08x  read = 0x%08x\n",addr,test_data,read_data);
         error_cnt = error_cnt + 1;
          if (error_cnt > MAX_NUMBER_OF_PRINTS) return -1 ;
    }




  if (error_cnt == 0) {
     return 0 ; }
    else {
     return -1 ;}
}






























