/* $ZEL: sis1100pci_var.h,v 1.2 2002/02/27 09:59:03 wuestner Exp $ */

/*
 * Copyright (c) 2001
 * 	Peter Wuestner.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _sis1100_var_h_
#define _sis1100_var_h_

#include "linux/ioctl.h"

struct sis1100_mapinfo {
  int space;
  off_t offset;
  size_t size;
};

struct sis1100_ident_dev {
    int hw_type;
    int hw_version;
    int fw_type;
    int fw_version;
};

struct sis1100_ident {
    struct sis1100_ident_dev local;
    int remote_online;
};

struct sis1100_command {
    struct timeval timeout;
    int data[190];
};

#define GLINK_MAGIC 'p'

#define SIS1100_MAPINFO         _IOWR(GLINK_MAGIC, 12, struct sis1100_mapinfo)
#define SIS1100_LAST_ERROR      _IOR(GLINK_MAGIC,  13, u_int32_t)
#define SIS1100_IDENT           _IOR(GLINK_MAGIC,  14, struct sis1100_ident)
#define SIS1100_BIGENDIAN       _IOWR(GLINK_MAGIC, 16, int)
#define SIS1100_KIO_LEN         _IOWR(GLINK_MAGIC, 20, int[2])
#define SIS1100_COMMAND_READ    _IOR (GLINK_MAGIC, 21, struct sis1100_command)
#define SIS1100_COMMAND_WRITE   _IOW (GLINK_MAGIC, 22, struct sis1100_command)

#define SIS1100_CLEAR_USE_COUNT _IO(GLINK_MAGIC,  101)
#define SIS1100_DUMP            _IO(GLINK_MAGIC,  102)

#endif
