#include "MCeCoCom.h"

#include <iostream>

using namespace std;

bool MCeCoCom::InterpreteCmd(TString cmd, TString str)
{
    cout << cmd << ": " << str << endl;
    return true;
}

bool MCeCoCom::InterpreteStr(TString str)
{
    const Ssiz_t tok  = str.First(' ');
    const TString cmd = str(0, tok);
    str.Remove(0, tok+1);

    if (cmd==(TString)"CC-REPORT" && str.EndsWith("OVER"))
    {
        cout << cmd << ": " << str << endl;
        int y, m, d, h, min, s, ms, len;

        int n=sscanf(str.Data(),
                     "%02d %04d %02d %02d %02d %02d %02d %03d %n",
                     &fCCStatus, &y, &m, &d, &h, &min, &s, &ms, &len);
        if (n!=8)
        {
            cout << "Communication Problem: Wrong number of arguments" << endl;
            fComStat = kComProblem;
            return false;
        }
        str.Remove(0, len+1);

        fT.SetTimer(y, m, d, h, min, s, ms/1000.);

        // Remove the 29 tokens of the subsystem status
        //  table 12.1 p59
        for (int i=0; i<29; i++)
            str.Remove(0, str.First(' ')+1);

        // skip solar_irr_Wm2, wind_speed, UPS
		float zd, az, dec, ra, temp, hum;
        n=sscanf(str.Data(),
                 "%f %f %f %f %f %*f %*f %f %*f %n",
                 &zd, &az, &dec, &ra, &temp, &hum, &len);
        if (n!=6)
        {
            cout << "Communication Problem: Wrong number of arguments" << endl;
            fComStat = kComProblem;
            return false;
        }
        str.Remove(0, len);

        if (str!=(TString)"OVER")
        {
            cout << "Communication Problem: Termination (OVER) not found." << endl;
            fComStat = kComProblem;
            return false;
        }

        cout << "Zd/Az: " << zd << "/" << az << "   ";
        cout << "Ra/Dec: " << ra << "/" << dec << "   ";
        cout << "Temp:  " << temp << "'C   ";
        cout << "Hum: " << hum << "%" << endl;

        fHumidity = hum;
        fTemperature = temp;

        fComStat = kCmdReceived;
        return true;
    }

    const bool rc = InterpreteCmd(cmd, str);
    fComStat = rc ? kCmdReceived : kComProblem;
    return rc;
}

bool MCeCoCom::Send(const char *str)
{
    Timer t;
    t.Now();

    const char *msg =
        Form("%s "
             "%02d %04d %02d %02d %02d %02d %02d %03d "
             "%02d %04d %02d %02d %02d %02d %02d %03d "
             "%s\n", (const char*)fCommand,
             fStatus, t.Year(), t.Month(), t.Day(), t.H(), t.M(), t.S(), t.MilliSec(),
             fComStat, fT.Year(), fT.Month(), fT.Day(), fT.H(), fT.M(), fT.S(), fT.MilliSec(),
             str);

    const bool rc = MTcpIpIO::Send(msg);
    fComStat = rc ? kNoCmdReceived : kComProblem;
    return rc;
}
