/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationPINDiode                                                            //
//                                                                         //
// This is the storage container to hold informations about the pedestal   //
// (offset) value of one Pixel (PMT).                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationPINDiode.h"

#include "MLog.h"

ClassImp(MCalibrationPINDiode);

using namespace std;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
MCalibrationPINDiode::MCalibrationPINDiode(const char *name, const char *title)
    : fHist(NULL)
{

  fName  = name  ? name  : "MCalibrationPINDiode";
  fTitle = title ? title : "Container of the MHCalibrationPINDiode and the fit results";

  fHist = new MHCalibrationPINDiode();

  fQ   = fErrQ     = 0.;
  fPed = fPedRms   = 0.;
  fT   = fErrT  = 0.;
  fRQ  = fErrRQ = 0.;
  fSigmaQ = fErrSigmaQ = 0.;

}

MCalibrationPINDiode::~MCalibrationPINDiode() 
{
  delete fHist;
}

// ------------------------------------------------------------------------
//
// Invalidate values
//
void MCalibrationPINDiode::Clear(Option_t *o)
{
  fHist->Reset();
}

Bool_t MCalibrationPINDiode::FitQ() 
{
  if(!fHist->FitQ())
    return kFALSE;

  fQ         = fHist->GetQMean();
  fErrQ      = fHist->GetQMeanErr(); 
  fSigmaQ    = fHist->GetQSigma();
  fErrSigmaQ = fHist->GetQSigmaErr();

  return kTRUE;
  
}

Bool_t MCalibrationPINDiode::FitT() 
{

  if(!fHist->FitT())
    return kFALSE;

  fT = fHist->GetT();
  fErrT = fHist->GetErrT();
  
  return kTRUE;

}
