#ifndef MARS_MCalibrationPINDiode
#define MARS_MCalibrationPINDiode

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#include "MHCalibrationPINDiode.h"

class MCalibrationPINDiode : public MParContainer
{
private:

  Float_t fQ;                // The mean charge after the fit
  Float_t fErrQ;             // The error of mean charge after the fit
  Float_t fPed;              // The mean pedestal (from MPedestalPix)
  Float_t fPedRms;           // The pedestal  RMS (from MPedestalPix)
  Float_t fSigmaQ;           // The sigma of the mean charge after the fit
  Float_t fErrSigmaQ;        // The error of the sigma of the mean charge after the fit
  Float_t fT;                // The mean arrival time after the fit  
  Float_t fErrT;             // The error of the mean arrival time after the fit
  
  Float_t fRQ;               // The reduced mean charge after the fit
  Float_t fErrRQ;            // The error of the reduced mean charge after the fit  
  
  MHCalibrationPINDiode *fHist; // Pointer to the histograms performing the fits, etc.  
  
public:

  MCalibrationPINDiode(const char *name=NULL, const char *title=NULL);
  ~MCalibrationPINDiode();
  
  void Clear(Option_t *o="");
  
  void SetPed(Float_t ped)         { fPed      = ped;      } 
  void SetPedRms(Float_t pedrms)    { fPedRms   = pedrms; }

  Bool_t IsValid() const { return fRQ >=0 || fErrRQ >= 0; }

  Bool_t FillQ(Int_t q)            { return fHist->FillQ(q); }
  Bool_t FillT(Int_t t)            { return fHist->FillT(t); }  
  Bool_t FillRQvsT(Float_t rq, Int_t t) { return fHist->FillQvsN(rq,t); }    
  
  Bool_t FitQ();
  Bool_t FitT();
  
  MHCalibrationPINDiode *GetHist()  const  { return fHist;  }
  
  ClassDef(MCalibrationPINDiode, 1)	// Storage Container for Calibration information of one pixel
};

#endif   /* MARS_MCalibrationPINDiode */

