#ifndef MARS_MHCalibrationConfig
#define MARS_MHCalibrationConfig

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MHCalibrationConfig                                                     //
//                                                                         //
// Contains all configuration data of the Calibration                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////


// Global rejection criteria for the acceptance of a fit: Prob=0.01 == 99% Probability
const Float_t gkProbLimit = 0.01;

// Starting number of bins for the histo:
const Int_t gkStartBlindPixelBinNr = 10000;

// Starting number of bins for the histo: (maximum by hardware: 4080)
const Int_t gkStartPINDiodeBinNr = 4000;

// Starting number of bins for the histo: (maximum possible by hardware = 40800)
const Int_t gkStartPixelBinNr = 20000;

// Starting number for the highest value of the Q-histo:
const Axis_t gkStartQlast      = 5000.;

// Square root of 2 pi:
const Float_t gkSq2Pi = 2.506628274631;

// typedef to the fitting functions for the blind pixel
typedef Double_t (*BPFitFunc)(Double_t *, Double_t *);

#endif /* MARS_MHCalibrationBlindPixelConfig */
