#ifndef MARS_MCameraLV
#define MARS_MCameraLV

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MCameraPowerSupply
#include <MCameraPowerSupply.h>
#endif

class MCameraLV : public MParContainer
{
    friend class MReportCamera;
private:
    Bool_t  fStatus;                    // Monitored status:  , Cam.LV_state
    Bool_t  fRequestPowerSupply;        // Requested status: o=off, 1=on, blv_ps_status
    Bool_t  fRequestTemp;               // Requested status: o=off, 1=on, blv_temp
    Bool_t  fRequestHumidity;           // Requested status: o=off, 1=on, blv_RelativeHumidity

    MCameraPowerSupply fPowerSupplyA;   // power supply A
    MCameraPowerSupply fPowerSupplyB;   // power supply B

    Float_t fVoltageOptLinkPos12V;      // [V] voltage_opt_link_pos12
    Float_t fVoltageOptLinkSparePos12V; // [V] voltage_opt_link_spare_pos12

    Float_t fCurrentOptLinkPos12V;      // [A] current_opt_link_pos12
    Float_t fCurrentOptLinkSparePos12V; // [A] current_opt_link_spare_pos12

public:
    ClassDef(MCameraLV, 0)
};

#endif
