#ifndef MARS_MReportCamera
#define MARS_MReportCamera

#ifndef MARS_MReport
#include "MReport.h"
#endif
/*
class MCameraCooling : public MParContainer
{
    friend class MReportCamera;
private:
    Bool_t  fStatus;              // Monitored status: , Cam.COOLING_state

    Bool_t  fStatusPressureHi;    // 0=ok,  1=Obstruct
    Bool_t  fStatusPressureLo;    // 0=ok,  1=leakage
    Bool_t  fStatusPumb;          // 0=off, 1=on
    Bool_t  fStatusRefrigrerator; // 0=off, 1=on
    Bool_t  fStatusValve;         // 0=recirculate, 1=new
    Bool_t  fStatusResistor;      // 0=off, 1=on
    Bool_t  fStatusFans;          // 0=off, 1=on

    Float_t fTempCenter;          // [deg C] Temperature at the camera center
    Float_t fTempWall;            // [deg C] Temperature at the camera wall
    Float_t fTempOptLink;         // [deg C] Temperature at the optical link
    Float_t fTempWater;           // [deg C] Temperature of the water

    Byte_t  fHumAll;              // [%] Relative humidity over all
    Byte_t  fHumCenter;           // [%] Relative humidity camera center

public:
    ClassDef(MCameraCooling, 0)
};
class MCameraLid : public MParContainer
{
    friend class MReportCamera;
private:
     Bool_t fLimitTop;         // 0=not active, 1= active
     Bool_t fLimitBottom;      // 0=not active, 1= active
     Bool_t fSaftyLimitTop;    // 0=not active, 1= active
     Bool_t fSaftyLimitBottom; // 0=not active, 1= active
     Byte_t fStatusLid;        // 0=positioning, 1=open, 2=closed
     Byte_t fStatusMotor;      // 0=stopped, 1=opening, 2=closing
public:
    ClassDef(MCameraLid, 0)
};
class MCameraLids : public MParContainer
{
    friend class MReportCamera;
private:
    MCameraLid *fLidA;
    MCameraLid *fLidB;

    Bool_t fStatus; // [?] Monitored status, Cam.LID_state
public:
    ClassDef(MCameraLids, 0)
};

class MCameraPowerSupply : public MParContainer
{
    friend class MReportCamera;
private:
     Float_t fVoltagePos5V;  // [V] voltage_pos5
     Float_t fVoltagePos12V; // [V] voltage_pos12
     Float_t fVoltageNeg12V; // [V] voltage_neg12
     Float_t fCurrentPos5V;  // [A] current_pos5
     Float_t fCurrentPos12V; // [A] current_pos12
     Float_t fCurrentNeg12V; // [A] current_neg12
public:
    ClassDef(MCameraPowerSupply, 0)
};

class MCameraLV : public MParContainer
{
    friend class MReportCamera;
private:
    Bool_t  fStatus;                    // Monitored status:  , Cam.LV_state
    Bool_t  fRequestPowerSupply;        // Requested status: o=off, 1=on, blv_ps_status
    Bool_t  fRequestTemp;               // Requested status: o=off, 1=on, blv_temp
    Bool_t  fRequestHumidity;           // Requested status: o=off, 1=on, blv_RelativeHumidity

    MCameraPowerSupply fPowerSupplyA;  // power supply A
    MCameraPowerSupply fPowerSupplyB;  // power supply B

    Float_t fVoltageOptLinkPos12V;      // [V] voltage_opt_link_pos12
    Float_t fVoltageOptLinkSparePos12V; // [V] voltage_opt_link_spare_pos12

    Float_t fCurrentOptLinkPos12V;      // [A] current_opt_link_pos12
    Float_t fCurrentOptLinkSparePos12V; // [A] current_opt_link_spare_pos12

public:
    ClassDef(MCameraLV, 0)
};

class MCameraAUX : public MParContainer
{
    friend class MReportCamera;
private:
    Bool_t fRequestCaosLEDs; // Requested status: o=off, 1=on, bAux_CaOsLEDs_Off/On
    Bool_t fRequestFansFADC; // Requested status: o=off, 1=on, bAux_FADC_FANs_Off/On
    Bool_t fStatusCaosLEDs;  // Monitored status: o=off, 1=on, Cam.CaOs.LED_state
    Bool_t fStatusFansFADC;  // Monitored status: o=off, 1=on, Cam.FADC.Fans_state
public:
    ClassDef(MCameraAUX, 0)
};

class MCameraCalibration : public MParContainer
{
    friend class MReportCamera;
private:
    Bool_t fStatus;           // Monitored status: o=off, 1=on, CamCalib_state
    Bool_t fStatusCANbus;     // Monitored status: o=off, 1=on, Cal.CanBus_state
    Bool_t fStatusIO;         // Monitored status: o=off, 1=on, Cal.IO_state
    Bool_t fStatusLoVoltage;  // Monitored status: o=off, 1=on, Cal.LV_state

    Bool_t fRequestHiVoltage; // Requested status: o=off, 1=on, bcalib_HV_Off/On
    Bool_t fRequestLoVoltage; // Requested status: o=off, 1=on, bcalib_LV_Off/On
    Bool_t fRequestContLight; // Requested status: o=off, 1=on, bcalib_ContinuousLight_Off/On
    Bool_t fRequestPinDiode;  // Requested status: o=off, 1=on, bcalib_PinDiode_Off/On

public:
    ClassDef(MCameraCalibration, 0)
};
#include <TArrayS.h>
class MCameraHV : public MParContainer
{
    friend class MReportCamera;
private:
    Bool_t  fStatus;            // Monitored status of the High Voltage, Cam.HV.PS_state
    Bool_t  fStatusPowerSupply; // Monitored status of the HV Power supply, Cam.HV_state

    Short_t fVoltageA;          // [V] Measured voltage of power supply A, hvps1
    Short_t fVoltageB;          // [V] Measured voltage of power supply B, hvps2

    Short_t fCurrentA;          // [A] Measured current of power supply A, curr1
    Short_t fCurrentB;          // [A] Measured current of power supply B, curr2

    TArrayS fHV;                // [V] Measured high Voltages for all PMTs
public:
    MCameraHV() : fHV(577) { }
    ClassDef(MCameraHV, 0)
};
*/

class MCameraCooling;
class MCameraLids;
class MCameraHV;
class MCameraLV;
class MCameraCalibration;

class MReportCamera : public MReport
{
private:
    Bool_t fStatus;   // [?] Monitored status of the sentinel, Sentinel_state
    Bool_t fStatusDC; // [?] Monitored status of the DC currents, Cam.DC_state

    MCameraCooling     *fCooling;
    MCameraLids        *fLids;
    MCameraHV          *fHV;
    MCameraLV          *fLV;
    MCameraCalibration *fCalibration;

    Bool_t SetupReading(MParList &plist);
    Bool_t CheckTag(TString &str, const char *tag) const;

    Bool_t InterpreteDC(TString &str);
    Bool_t InterpreteHV(TString &str);
    Bool_t InterpreteCOOL(TString &str);
    Bool_t InterpreteLID(TString &str);
    Bool_t InterpreteHVPS(TString &str);
    Bool_t InterpreteLV(TString &str);
    Bool_t InterpreteAUX(TString &str);
    Bool_t InterpreteCAL(TString &str);

public:
    MReportCamera();

    Bool_t InterpreteBody(TString &str);

    ClassDef(MReportCamera, 1) // Base class for control reports
};

#endif
