#ifndef MARS_MCalibrationPix
#define MARS_MCalibrationPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#include "MHCalibrationPixel.h"

class MCalibrationPix : public MParContainer
{
private:

  //
  // FIXME: Derive class from MCerphotPix ??
  //
  Int_t   fPixId;           // the pixel Id
  
  Float_t fQ;                // The mean charge after the fit
  Float_t fErrQ;             // The error of mean charge after the fit
  Float_t fQProb;            // The probability of the fit function 
  Float_t fPed;              // The mean pedestal (from MPedestalPix)
  Float_t fPedRms;           // The pedestal  RMS (from MPedestalPix)
  Float_t fSigmaQ;           // The sigma of the mean charge after the fit
  Float_t fErrSigmaQ;        // The error of the sigma of the mean charge after the fit
  Float_t fT;                // The mean arrival time after the fit  
  Float_t fErrT;             // The error of the mean arrival time after the fit
  Float_t fTProb;            // The probability of the fit function 
  
  Float_t fRQ;               // The reduced mean charge after the fit
  Float_t fErrRQ;            // The error of the reduced mean charge after the fit  
  
  MHCalibrationPixel *fHist; // Pointer to the histograms performing the fits, etc.  
  
public:

  MCalibrationPix(Int_t pix=-1, const char *name=NULL, const char *title=NULL);
  ~MCalibrationPix();
  
  void Clear(Option_t *o="");

  Float_t GetQ()     const    { return fQ;     }
  Float_t GetRQ()    const    { return fRQ;    }
    
  Float_t GetErrQ()  const    { return fErrQ;  }
  Float_t GetErrRQ() const    { return fErrRQ; }    
  Float_t GetQProb() const    { return fQProb;    }    
  
  Float_t GetSigmaQ()    const   { return fSigmaQ;    }
  Float_t GetErrSigmaQ() const   { return fErrSigmaQ; }
  Float_t GetT()         const   { return fT;         }
  Float_t GetErrT()      const   { return fErrT;      }
  Float_t GetTProb()     const   { return fTProb;    }    
  
  Float_t GetPed()       const    { return fPed;     }
  Float_t GetPedRms()    const    { return fPedRms;    }    

  void SetPedestal(Float_t ped, Float_t pedrms);       

  Bool_t FillQ(Int_t q)                 { return fHist->FillQ(q); }
  Bool_t FillT(Int_t t)                 { return fHist->FillT(t); }  
  Bool_t FillRQvsT(Float_t rq, Int_t t) { return fHist->FillQvsN(rq,t); }    
  
  Bool_t IsValid()      const           { return fRQ >=0 || fErrRQ >= 0; }
  Int_t  GetPixId()     const           { return fPixId;   }

  Bool_t FitQ();
  Bool_t FitT();
  
  MHCalibrationPixel *GetHist()     const  { return fHist;  }
  virtual void Draw(Option_t *opt="")     { fHist->Draw(opt); }
  
  void Test();
    
  ClassDef(MCalibrationPix, 1)	// Storage Container for Calibration information of one pixel
};

#endif

