#ifndef HVFEEDBACK_H_SEEN
#define HVFEEDBACK_H_SEEN

#define BUF_LENGTH 1000

#include <stdlib.h>
#include <math.h>
#include <sstream>
#include <vector>

#include "RawDataCTX.h"
#include "DAQReadout.h"

enum FBState {FB_Off, FB_Active, FB_Targets, FB_ResponseFirst, FB_ResponseSecond};

class HVFeedback: public DimServer {

    class DAQReadout *m;
    class PixelMap *PixMap;
    FBState FBMode;
    
    float (*Average)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Sigma)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Response)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Target)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*Buffer)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*DIMAverage)[kNumberOfChipsMax][kNumberOfChannelsMax];
    float (*DIMSigma)[kNumberOfChipsMax][kNumberOfChannelsMax];

	DimService *FeedbackAverage;
	DimService *FeedbackSigma;
	DimService *FeedbackResponse;
	DimService *FeedbackTarget;
	DimService *CountService;
	DimService *FeedbackState;

	struct {
      int State;
	  char Text[BUF_LENGTH];
	} State;

	int NumAverages;	// Events to take before feedback acts
	int Count;		// Number of currently integrated events
    int LastServiceUpdate;

    float Gain;     	    	// Feedback gain
    float DiffVoltage;	    	// for response measurement	
    char TextBuf[BUF_LENGTH];
	
    int fLedTrigBoard;
    int fLedTrigChip;
    int fLedTrigChannel;
    int fLedTrigSample;
    float fLedTrigThreshold;
    int fLedSignalSample;
    int fLedBaselineSample;
    unsigned int fIntHalfWidth;
    int fDefaultNumAverage;

    int fNumberOfChannels;
    int fNumberOfChips;
    
  public:
    HVFeedback(class DAQReadout*);
    ~HVFeedback();

    bool ProcessEvent();
    void SetTarget(int, int, int, float);
    void GetTargets();
    void SetGain(float);
    float GetGain();
    void SetNumAverages(unsigned int);
    unsigned int GetNumAverages();
    void SetFBMode(FBState, bool=false);
    FBState GetFBMode();
    unsigned int GetCurrentCount();
    void MeasureResponse(float);
    void GetResponse();
    void ClearAverages();
    void PrintConfig();
};

#endif
