#ifndef MARS_MCameraHV
#define MARS_MCameraHV

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MCameraHV : public MParContainer
{
    friend class MReportCamera;
private:
    Byte_t  fStatus;        // CaCo monitored status of the High Voltage [0-9], Cam.HV.PS_state
    Bool_t  fStatusRamping; // CaCo monitored status of ramping the HV, Cam.HV_state

    Short_t fVoltageA;      // [V] Measured voltage of power supply A, hvps1
    Short_t fVoltageB;      // [V] Measured voltage of power supply B, hvps2

    Byte_t fCurrentA;       // [mA] Measured current of power supply A, curr1
    Byte_t fCurrentB;       // [mA] Measured current of power supply B, curr2

    TArrayS fHV;            // [V] Measured high Voltages for all PMTs
public:
    MCameraHV() : fHV(577) { }
    ClassDef(MCameraHV, 0)
};

#endif
