#ifndef MARS_MCameraLV
#define MARS_MCameraLV

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MCameraPowerSupply
#include <MCameraPowerSupply.h>
#endif

class MCameraLV : public MParContainer
{
    friend class MReportCamera;
private:
    Byte_t  fStatus;                    // CaCo monitored LV PS status:  , Cam.LV_state
    Bool_t  fRequestPowerSupply;        // Requested status: o=off, 1=on, blv_ps_status

    Float_t  fStatusTemp;               // Measured status: o=off, 1=on, blv_temp
    Float_t  fStatusHumidity;           // Measured status: o=off, 1=on, blv_RelativeHumidity

    MCameraPowerSupply fPowerSupplyA;   // power supply camera part A
    MCameraPowerSupply fPowerSupplyB;   // power supply camera part B

public:
    ClassDef(MCameraLV, 0)
};

#endif
