#ifndef MARS_MReadReports
#define MARS_MReadReports

#ifndef MARS_MRead
#include "MRead.h"
#endif

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class TChain;
class MTime;
class MTaskList;

class MReadReports : public MRead
{
private:
    MTaskList *fTrees;
    TList *fChains;

    TArrayL fPos;

    MTask *fList;

    MTime** GetTime(TChain *c) const;

    UInt_t GetEntries() { return 0; }

public:
    MReadReports(); 
    ~MReadReports(); 

    void  AddTree(const char *tree, const char *time=NULL);
    Int_t AddFile(const char *fname, Int_t entries=-1);
    void  AddToBranchList(const char *name);

    void PrintStatistics(const Int_t lvl=0, Bool_t title=kFALSE) const;

    Int_t PreProcess(MParList *plist);
    Int_t Process();
    Int_t PostProcess();

    ClassDef(MReadReports, 0)	// Base class for a reading task
};

#endif
