#ifndef MARS_MOnlineDisplay
#define MARS_MOnlineDisplay

#ifndef MARS_MStatusDisplay
#include "MStatusDisplay.h"
#endif

class TGLabel;
class TGTextEntry;
class MEvtLoop;

class MParList;
class MTaskList;
class MReadTree;
class MGTask;

class MOnlineDisplay : public MStatusDisplay
{
    friend class MOnlineDump;
public:
    enum
    {
        kSlider = MStatusDisplay::kSearch + 1,
        kFreeze
    };

private:
    TGCompositeFrame *fTab1;
    TGCompositeFrame *fTab2;

    //TGLabel  *fNumOfEvts;
    TCanvas  *fCanvas;
    //MEvtLoop *fEvtLoop;

    MGTask *fTask;

    void AddTopFramePart1(TGCompositeFrame *frame);
    void AddTopFramePart2(TGCompositeFrame *frame);
    void AddGeometryTab();
    void AddUserFrame(const char *filename);

    void UpdateDisplay();
    //void SetupTaskList(const char *tname, const char *fname);

    //void ReadFirstEvent();
    //void ReadinEvent(Int_t dir=0);

    //MReadTree *GetReader() const;

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

public:
    MOnlineDisplay();
    ~MOnlineDisplay();

    void SetTask(MGTask *t) { fTask=t; }

    ClassDef(MOnlineDisplay, 0) // Display for camera images (cerenkov events)
};

#endif


