#ifndef MARS_MEventRateCalc
#define MARS_MEventRateCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif

class MEventRate;

class MEventRateCalc : public MTask
{
    MTime      *fTime;  //!
    MEventRate *fRate;  //!

    ULong_t fEvtNumber; //!
    MTime   fEvtTime;   //!

    UInt_t  fNumEvents;

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MEventRateCalc(const char *name=NULL, const char *title=NULL);

    void SetNumEvents(ULong_t num) { fNumEvents = num; }

    ClassDef(MEventRateCalc, 0)// Task to calculate event rates
};
 

#endif
