/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Wolfgang Wittek  11/2003 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MFRandomSplit                                                         //
//                                                                         //
//  A filter which gives fResult = kTRUE with the probability fProb        //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MFRandomSplit.h"

#include <fstream>
#include <TRandom.h>

#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MFRandomSplit);

using namespace std;

// --------------------------------------------------------------------------
//
//     Constructor
//
MFRandomSplit::MFRandomSplit(Double_t f, const char *name, const char *title)
{
  fName  = name  ? name  : "MFRandomSplit";
  fTitle = title ? title : "Filter for random splitting";

  fProb = f;
  if (fProb <= 0.0)
    *fLog << "MFRandomSplit : fProb is less than 0" << endl;

  if (fProb > 1.0)
    *fLog << "MFRandomSplit : fProb is greater than 1" << endl;
}

// --------------------------------------------------------------------------
//
//   Preprocess
//  
//
Int_t MFRandomSplit::PreProcess(MParList *pList)
{
  fNumSelectedEvts = 0;

  return kTRUE;
}

// --------------------------------------------------------------------------
//  
//  Select events randomly according to the probability fProb
//
Int_t MFRandomSplit::Process()
{
  fResult = gRandom->Uniform() < fProb;

  if (!fResult)
      return kTRUE;

  fNumSelectedEvts++;

  return kTRUE;
}


// --------------------------------------------------------------------------
//  
//  PostProcess
//
Int_t MFRandomSplit::PostProcess()
{
  *fLog << "MFRandomSplit::PostProcess; " << fNumSelectedEvts 
        << " were selected out of "       << GetNumExecutions() << endl;

  return kTRUE;
}

//============================================================================












