/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 11/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

void readrep(const char *fname="CC_2003_11_04_23_53_18.rep")
{
    MParList  plist;
    MTaskList tlist;
    plist.AddToList(&tlist);

    MReportFileRead read(fname);
    tlist.AddToList(&read);

    MReportDAQ daq;
    MReportDrive drive;
    MReportCamera camera;
    MReportTrigger trigger;
    read.AddToList(&daq);
    read.AddToList(&drive);
    read.AddToList(&camera);
    read.AddToList(&trigger);

    MWriteRootFile write("test.root");
    write.AddContainer("MReportDAQ",     "DAQ");
    write.AddContainer("MTimeDAQ",       "DAQ");
    write.AddContainer("MReportDrive",   "Drive");
    write.AddContainer("MTimeDrive",     "Drive");
    write.AddContainer("MReportTrigger", "Trigger");
    write.AddContainer("MTimeTrigger",   "Trigger");
    write.AddContainer("MReportCamera",  "Camera");
    write.AddContainer("MTimeCamera",    "Camera");
    tlist.AddToList(&write);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    return;
    // ------------------------------------------

    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    MTaskList list1("ProcessCamera");
    MPrint print1("MTimeCamera");
    list1.AddToList(&print1);

    MTaskList list2("ProcessDAQ");
    MPrint print2("MTimeDAQ");
    list2.AddToList(&print2);

    MReadReports read;
    read.AddTree("DAQ");
    read.AddTree("Drive");
    read.AddTree("Trigger");
    read.AddTree("Camera");
    //read.AddTree("Events", "MTime");

    read.AddFile("test.root");

    tlist.AddToList(&read);
    tlist.AddToList(&list1, "Camera");
    tlist.AddToList(&list2, "DAQ");


    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.Eventloop())
        return;

    plist.Print();
    tlist.PrintStatistics();
}
