#ifndef MARS_MReadReports
#define MARS_MReadReports

#ifndef MARS_MRead
#include "MRead.h"
#endif

#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class TChain;
class MTime;
class MTaskList;

class MReadReports : public MRead
{
private:
    MTaskList *fTrees;  // Hold the trees which are scheduled for reading
    TList     *fChains; // Hold TChains to read the times in advance

    TArrayL    fPos;    // Store the position in each tree/chain

    MTask     *fList;   // pointer to the task list to set the stream id

    MTime** GetTime(TChain *c) const;

    UInt_t  GetEntries() { return 0; }

    Int_t   PreProcess(MParList *plist);
    Int_t   Process();
    Int_t   PostProcess();

public:
    MReadReports(); 
    ~MReadReports(); 

    void  AddTree(const char *tree, const char *time=NULL);
    Int_t AddFile(const char *fname, Int_t entries=-1);
    void  AddToBranchList(const char *name);

    void  PrintStatistics(const Int_t lvl=0, Bool_t title=kFALSE) const;

    ClassDef(MReadReports, 0) // Reads events and reports from a root file ordered in time
};

#endif
