#ifndef MARS_MReportFileRead
#define MARS_MReportFileRead

#ifndef MARS_MTask
#include "MTask.h"
#endif

// gcc 3.2
//class ifstream;
#include <iosfwd>

class THashTable;

class MTime;
class MReport;
class MReportHelp;

class MReportFileRead : public MTask
{
private:
    static const TString gsReportHeader;
    static const TString gsVersionPrefix;

    TString     fFileName;
    ifstream   *fIn;         //! buffered input stream (file to read from)

    THashTable *fList;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    Bool_t CheckFileHeader() const;
    MReport *GetReport(const TString &str) const;
    MReport *GetReport(MReportHelp *help) const;
    MReportHelp *GetReportHelp(const TString &str) const;

public:
    MReportFileRead(const char *filename, const char *name=NULL, const char *title=NULL);
    ~MReportFileRead();

    Bool_t AddToList(const char *name) const;

    ClassDef(MReportFileRead, 0)// Task to read the central control report file
};

#endif
