/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 11/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MReportCurrents
//
// This is the class interpreting and storing the DC-REPORT information.
//
// --> Not yet finished...
//
//////////////////////////////////////////////////////////////////////////////
#include "MReportCurrents.h"

#include "MLogManip.h"

#include "MAstro.h"

ClassImp(MReportCurrents);

using namespace std;

MReportCurrents::MReportCurrents() : MReport("DC-REPORT"), fCurrents(577)
{
    fName  = "MReportCurrents";
    fTitle = "Class for DC-REPORT information";
}

// Currents-REPORT 02 2003 11 04 23 53 34 951 00 0000 00 00 23 53 32 466
// 00000000 05394281 066555    0.0    0.0 000000  0.0000 00099999 099999 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 OVER
Bool_t MReportCurrents::InterpreteBody(TString &str)
{
    Int_t len;
    Short_t err1, err2;
    const Int_t n=sscanf(str.Data(), " %hd %hd %n",
                         &err1, &err2, &len);
    if (n!=2)
    {
        *fLog << err << "ERROR - Reading information of 'LV' section." << endl;
        return kFALSE;
    }

    fStatus1 = (Byte_t)err1;
    fStatus2 = (Byte_t)err2;

    const char *pos = str.Data()+len;
    const char *end = pos+577*4;

    Int_t i=0;
    while (pos<end)
    {
        Int_t c;
        const Char_t hex[5] = { pos[0], pos[1], pos[2], pos[3], 0 };
        pos += 4;

        const Int_t n=sscanf(hex, "%4x", &c);
        if (n!=1)
        {
            *fLog << err << "ERROR - Reading hexadecimal DC information." << endl;
            return kFALSE;
        }

        fCurrents[i++] = 0.001*c;
    }

    str.Remove(0, pos-str.Data()); // Remove DC currents
    str=str.Strip(TString::kLeading);

    return kTRUE;
}
