#ifndef MARS_MCalibrationBlindPix
#define MARS_MCalibrationBlindPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#include "MHCalibrationBlindPixel.h"

class MCalibrationBlindPix : public MParContainer
{
private:

  Float_t fLambda;           // The mean charge after the fit
  Float_t fMu0;              // The position of the pedestal-peak
  Float_t fMu1;              // The position of the first phe-peak
  Float_t fSigma0;           // The width of the pedestal-peak
  Float_t fSigma1;           // The width of the first phe-peak  

  Float_t fErrLambda;        // The error of the mean charge after the fit
  Float_t fErrMu0;           // The error of the position of the pedestal-peak
  Float_t fErrMu1;           // The error of the position of the first phe-peak
  Float_t fErrSigma0;        // The error of the width of the pedestal-peak
  Float_t fErrSigma1;        // The error of the width of the first phe-peak  
  
  Float_t fT;                // The mean arrival time after the fit  
  Float_t fErrT;             // The error of the mean arrival time after the fit
  
  MHCalibrationBlindPixel *fHist; // Pointer to the histograms performing the fits, etc.  
  
public:

  MCalibrationBlindPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationBlindPix();
  
  void Clear(Option_t *o="");
  
  Float_t GetLambda()    const    { return fLambda;  }
  Float_t GetMu0()       const    { return fMu0;  }
  Float_t GetMu1()       const    { return fMu1;  }
  Float_t GetSigma0()    const    { return fSigma0;  }
  Float_t GetSigma1()    const    { return fSigma1;  }

  Float_t GetErrLambda() const    { return fErrLambda;  }
  Float_t GetErrMu0()    const    { return fErrMu0;  }
  Float_t GetErrMu1()    const    { return fErrMu1;  }
  Float_t GetErrSigma0() const    { return fErrSigma0;  }
  Float_t GetErrSigma1() const    { return fErrSigma1;  }

  Float_t GetT()         const    { return fT;         }
  Float_t GetErrT()      const    { return fErrT;      }
  
  Bool_t FillQ(Int_t q)            { return fHist->FillBlindPixelQ(q); }
  Bool_t FillT(Int_t t)            { return fHist->FillBlindPixelT(t); }  
  Bool_t FillRQvsT(Float_t rq, Int_t t) { return fHist->FillBlindPixelQvsN(rq,t); }    
  
  Bool_t IsValid()                 { return fLambda > 0. || fErrLambda > 0.; }
  
  Bool_t FitQ();
  Bool_t FitT();
  
  virtual void Draw(Option_t *opt="")         { fHist->Draw(opt); }
  MHCalibrationBlindPixel *GetHist()  const  { return fHist;  }
  
  ClassDef(MCalibrationBlindPix, 1)	// Storage Container for Calibration information of one pixel
};

#endif

