#ifndef MARS_MCalibrationCam
#define MARS_MCalibrationCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

#ifndef MARS_MCalibrationPix
#include "MCalibrationPix.h"
#endif

#ifndef MARS_MCalibrationBlindPix
#include "MCalibrationBlindPix.h"
#endif

#ifndef MARS_MCalibrationPINDiode
#include "MCalibrationPINDiode.h"
#endif

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif


class MGeomCam;
class MCalibrationPix;
class MCalibrationBlindPix;
class MCalibrationPINDiode;

class MCalibrationCam : public MCamEvent
{
private:
  
  Int_t fNumPixels;
  TClonesArray *fPixels;             // FIXME: Change TClonesArray away from a pointer?
  
  MCalibrationBlindPix *fBlindPixel; // containing blind pixel data with fitresults
  MCalibrationPINDiode *fPINDiode;   // containing PIN Diode data with fit results    

  Float_t fMeanNrPhotInnerPix;       // The mean number of photons in an inner pixel  
  Float_t fMeanNrPhotInnerPixErr;    // The uncertainty about the number of photons in an inner pixel  
  Bool_t  fMeanNrPhotAvailable;

  Bool_t CalcNrPhotInnerPixel();
  
public:
  
  enum CalibrationColor_t { kECGreen, kECBlue, kECUV };

private:

  CalibrationColor_t fColor;  
  
public:

  MCalibrationCam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationCam();
  
  void Clear(Option_t *o="");
  
  void InitSize(const Int_t i);
  Int_t GetSize() const;

  UInt_t GetNumPixels() const { return fNumPixels; }

  Bool_t IsPixelUsed(Int_t idx) const;
  Bool_t IsPixelFitted(Int_t idx) const;
  
  MCalibrationPix &operator[](Int_t i);
  MCalibrationPix &operator[](Int_t i) const;
  
  UShort_t FitQ(Int_t i=-1);
  UShort_t FitAllQ();
  UShort_t FitT(Int_t i=-1);
  UShort_t FitAllT();
  
  Bool_t CheckBounds(Int_t i) const;

  void Print(Option_t *o="") const;
  
  void CutEdges();
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t num) const;    
  
  MCalibrationPix      *GetCalibrationPix(Int_t idx) const;
  MCalibrationBlindPix *GetBlindPixel() const { return fBlindPixel; }
  MCalibrationPINDiode *GetPINDiode()   const { return fPINDiode; }

  void SetColor(CalibrationColor_t color)    { fColor = color; }

  Bool_t GetConversionFactor(Int_t ipx, Float_t &mean, Float_t &err);
  
  ClassDef(MCalibrationCam, 1)	// Storage Container for all calibration information of the camera
};

#endif

