#ifndef MARS_MHCalibrationBlindPixel
#define MARS_MHCalibrationBlindPixel

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MHCalibrationConfig
#include "MHCalibrationConfig.h"
#endif

#ifndef ROOT_TH1
#include "TH1.h"
#endif

#ifndef ROOT_TH1F
#include "TH1F.h"
#endif

#ifndef ROOT_TF1
#include "TF1.h"
#endif

#ifndef ROOT_TPaveText
#include "TPaveText.h"
#endif

class TMath;
class MParList;
class MHCalibrationBlindPixel : public MH
{
private:

  TH1I* fHBlindPixelQ;        //-> Histogram with the single Phe spectrum
  TH1F* fHBlindPixelErrQ;     //-> Variance of summed FADC slices
  TH1I* fHBlindPixelT;        //-> Variance of summed FADC slices
  TH1I* fHBlindPixelQvsN;     //-> Summed Charge vs. Event Nr. 
  
  TF1 *fSinglePheFit;
  TF1 *fTimeGausFit;  

  Axis_t  fBlindPixelQfirst;
  Axis_t  fBlindPixelQlast;
  Int_t   fBlindPixelQnbins;
  
  Axis_t fErrBlindPixelQfirst;
  Axis_t fErrBlindPixelQlast;
  Int_t  fErrBlindPixelQnbins;

  void ResetBin(Int_t i);
  void DrawLegend();

  TPaveText *fFitLegend;
  Bool_t fFitOK;  
  
  BlindPixelFitFunc fgSinglePheFitFunc;     // In the beginning, 
  Int_t     fgSinglePheFitNPar;     // we want to be flexible using different functions

  Double_t  fLambda; 
  Double_t  fMu0; 
  Double_t  fMu1; 
  Double_t  fSigma0; 
  Double_t  fSigma1; 

  Double_t  fLambdaErr; 
  Double_t  fMu0Err; 
  Double_t  fMu1Err; 
  Double_t  fSigma0Err; 
  Double_t  fSigma1Err; 

  Double_t  fChisquare; 
  Double_t  fProb;      
  Int_t     fNdf;       

  Double_t  fMeanT; 
  Double_t  fMeanTErr; 
  Double_t  fSigmaT; 
  Double_t  fSigmaTErr; 
  
public:

  MHCalibrationBlindPixel(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationBlindPixel();

  Bool_t FillBlindPixelQ(Int_t q)         { return fHBlindPixelQ->Fill(q) > -1;  }  
  Bool_t FillErrBlindPixelQ(Float_t errq) { return fHBlindPixelErrQ->Fill(errq) > -1; }
  Bool_t FillBlindPixelT(Int_t t)         { return fHBlindPixelT->Fill(t) > -1;  }
  Bool_t FillBlindPixelQvsN(Stat_t rq, Int_t t) { return fHBlindPixelQvsN->Fill(t,rq) > -1;  }  
  
  const Double_t GetLambda()   const { return fLambda; }
  const Double_t GetMu0()     const { return fMu0; }
  const Double_t GetMu1()     const { return fMu1; }
  const Double_t GetSigma0()   const { return fSigma0; }
  const Double_t GetSigma1()   const { return fSigma1; }

  const Double_t GetLambdaErr() const { return fLambdaErr; }
  const Double_t GetMu0Err()   const { return fMu0Err; }
  const Double_t GetMu1Err()   const { return fMu1Err; }
  const Double_t GetSigma0Err() const { return fSigma0Err; }
  const Double_t GetSigma1Err() const { return fSigma1Err; }

  const Double_t GetChiSquare() const { return fChisquare; }
  const Double_t GetProb()    const { return fProb;      }  
  const Int_t    GetNdf()     const { return fNdf;       }   

  const Double_t GetMeanT()      const { return fMeanT; }
  const Double_t GetMeanTErr()    const { return fMeanTErr; }
  const Double_t GetSigmaT()      const { return fSigmaT; }
  const Double_t GetSigmaTErr()    const { return fSigmaTErr; }

  const TH1F *GetHErrQ() { return fHBlindPixelErrQ; }
  const TH1F *GetHErrQ() const { return fHBlindPixelErrQ; }
  
  Bool_t SimulateSinglePhe(Double_t lambda,
                           Double_t mu0,
                           Double_t mu1,
                           Double_t sigma0,
                           Double_t sigma1);
  
  Bool_t FitSinglePhe(Axis_t rmin=0, Axis_t rmax=0, Option_t *opt="R0+");
  Bool_t FitT(Axis_t rmin=0., Axis_t rmax=0.,Option_t *opt="R0+");

  void ChangeFitFunc(BlindPixelFitFunc fitfunc, Int_t par=5);


  void CutAllEdges();
  void Draw(Option_t *option="");

  ClassDef(MHCalibrationBlindPixel, 0) 
};

#endif  /* MARS_MHCalibrationBlindPixel */
