#ifndef MARS_MHCalibrationPixel
#define MARS_MHCalibrationPixel

#ifndef ROOT_TH1
#include "TH1.h"
#endif

#ifndef ROOT_TH1
#include "TH1F.h"
#endif

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TF1
#include "TF1.h"
#endif

class TPaveText;
class TMath;
class MParList;

class MHCalibrationPixel : public MH
{

private:

  Int_t fPixId;           //-> Pixel Nr
  
protected:

  TH1I* fHQ;              //-> Summed FADC slices
  TH1I* fHT;              //-> Mean arrival time in number of FADC sice

  TH1I* fHQvsN;           //-> Summed Charge vs. Event Nr. 
  
  TF1* fQGausFit;
  TF1* fTGausFit;
  
  TPaveText *fFitLegend;  
  
  Axis_t  fLowerFitRange;
  Axis_t  fQfirst;
  Axis_t  fQlast;
  Int_t   fQnbins;

  Bool_t fFitOK;

  Double_t fQChisquare;
  Double_t fQProb;
  Int_t    fQNdf;

  Double_t fQMean;
  Double_t fQMeanErr;
  Double_t fQSigma;
  Double_t fQSigmaErr;
  
  Double_t fTChisquare;
  Double_t fTProb;
  Int_t    fTNdf;

  Double_t fTMean;
  Double_t fTSigma;
  
  virtual void DrawLegend();
  
public:

  MHCalibrationPixel(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationPixel();

  void ChangeHistId(Int_t i);
  
  Bool_t SetupFill(const MParList *pList);
  Bool_t Fill(const MParContainer *, const Stat_t w=1) { return kTRUE; }

  Bool_t FillQ(Int_t q) {  return fHQ->Fill(q) > -1;  }
  Bool_t FillT(Int_t t) {  return fHT->Fill(t) > -1;  }
  Bool_t FillQvsN(Float_t q, Int_t n) { return fHQvsN->Fill(n,q) > -1; }

  const TH1I *GetHQ()       { return fHQ; }
  const TH1I *GetHQ() const { return fHQ; }

  const Double_t GetQMean()    const { return fQMean; }
  const Double_t GetQMeanErr()  const { return fQMeanErr; }
  const Double_t GetQSigma()   const { return fQSigma; }
  const Double_t GetQSigmaErr() const { return fQSigmaErr; }
  const Double_t GetArea()    const { return fQGausFit->GetParameter(0); }
  const Double_t GetAreaErr()  const { return fQGausFit->GetParError(0); }

  const Double_t GetQChiSquare() const { return fQChisquare; }
  const Double_t GetQProb()    const { return fQProb;      }  
  const Int_t    GetQNdf()     const { return fQNdf;       }   

  const Double_t GetTMean()   const  { return fTMean; }
  const Double_t GetTSigma()  const  { return fTSigma; }

  const Double_t GetTChiSquare() const { return fTChisquare; }
  const Double_t GetTProb()      const { return fTProb; }
  const Int_t    GetTNdf()       const { return fTNdf;       }   
  
  const TH1I *GetHT()       { return fHT; }
  const TH1I *GetHT() const { return fHT; }
  
  const TH1I *GetHQvsN()       { return fHQvsN; }
  const TH1I *GetHQvsN() const { return fHQvsN; }
  
  Bool_t FitQ(Option_t *option="RQ0");  
  Bool_t FitT(Axis_t rmin=0, Axis_t rmax=0, Option_t *option="RQ0");    

  virtual void Draw(Option_t *option="");
  virtual void CutAllEdges();
  virtual void Reset();

  void SetLowerFitRange(Axis_t min)  { fLowerFitRange = min; }

  void PrintQFitResult();
  void PrintTFitResult();  

  Bool_t IsFitted()    { return fFitOK; }
  
  ClassDef(MHCalibrationPixel, 1) 
};

#endif
