#ifndef MARS_MPointingPositionCalc
#define MARS_MPointingPositionCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMcEvt;
class MReportDrive;
class MPointingPosition;

class MPointingPositionCalc : public MParContainer
{
private:
    MMcEvt            *fMcEvt;    //! MMcEvt to get simulated poiting position from
    MReportDrive      *fReport;   //! MReportDrive to get real poiting position from
    MPointingPosition *fPosition; //! Output container to store pointing position

    UShort_t fRunType;            //! Run Type to decide where to get pointing position from

    Bool_t ReInit(MParList *plist);
    Int_t  PreProcess(MParList *plist);
    Int_t  Process();

public:
    MPointingPositionCalc()
    {
        fName  = "MPointingPositionCalc";
        fTitle = "Task calculating the pointing position";
    }

    ClassDef(MPointingPositionCalc, 0) //Task calculating the pointing position
};

#endif
